/*
 * Decompiled with CFR 0.152.
 */
package co.uzzu.dotenv.gradle;

import co.uzzu.dotenv.gradle.Configuration;
import co.uzzu.dotenv.gradle.ConfigurationImpl;
import co.uzzu.dotenv.gradle.DefaultRootConfiguration;
import co.uzzu.dotenv.gradle.RootConfiguration;
import co.uzzu.dotenv.gradle.RootConfigurationImpl;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\tH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\u00020\u0018*\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0018H\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0003H\u0002J\u001c\u0010\u001a\u001a\u00020\u0012*\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lco/uzzu/dotenv/gradle/ConfigurationResolver;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "rootConfiguration", "Lco/uzzu/dotenv/gradle/RootConfiguration;", "getRootConfiguration", "()Lco/uzzu/dotenv/gradle/RootConfiguration;", "rootConfiguration$delegate", "Lkotlin/Lazy;", "createRootConfiguration", "resolve", "Lco/uzzu/dotenv/gradle/Configuration;", "resolveStringFor", "", "gradlePropertiesFromFile", "Ljava/util/Properties;", "key", "defaultValue", "ignoreParent", "", "boolProperty", "stringProperty", "plugin"})
@SourceDebugExtension(value={"SMAP\nConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Configuration.kt\nco/uzzu/dotenv/gradle/ConfigurationResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1#2:167\n*E\n"})
public final class ConfigurationResolver {
    @NotNull
    private final Project project;
    private final Logger logger;
    @NotNull
    private final Lazy rootConfiguration$delegate;

    public ConfigurationResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
        this.rootConfiguration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RootConfiguration>(this){
            final /* synthetic */ ConfigurationResolver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final RootConfiguration invoke() {
                return ConfigurationResolver.access$createRootConfiguration(this.this$0);
            }
        }));
    }

    private final RootConfiguration getRootConfiguration() {
        Lazy lazy = this.rootConfiguration$delegate;
        return (RootConfiguration)lazy.getValue();
    }

    @NotNull
    public final Configuration resolve() {
        Configuration configuration;
        if (Intrinsics.areEqual((Object)this.project, (Object)this.project.getRootProject())) {
            configuration = this.getRootConfiguration();
        } else {
            Properties gradlePropertiesFromFile = this.gradlePropertiesFromFile(this.project);
            configuration = new ConfigurationImpl(this.resolveStringFor(this.project, gradlePropertiesFromFile, "dotenv.filename", DefaultRootConfiguration.INSTANCE.getFilename(), this.getRootConfiguration().getIgnoreParentFilename()), this.resolveStringFor(this.project, gradlePropertiesFromFile, "dotenv.template.filename", DefaultRootConfiguration.INSTANCE.getTemplateFilename(), this.getRootConfiguration().getIgnoreParentTemplateFilename()));
        }
        return configuration;
    }

    private final String resolveStringFor(Project project, Properties gradlePropertiesFromFile, String key, String defaultValue, boolean ignoreParent) {
        String string;
        if (ignoreParent) {
            String string2 = gradlePropertiesFromFile.getProperty(key, defaultValue);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = this.stringProperty(project, key, defaultValue);
        }
        return string;
    }

    private final RootConfiguration createRootConfiguration() {
        Project it = this.project.getRootProject();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return new RootConfigurationImpl(this.boolProperty(it, "dotenv.filename.ignore.parent", DefaultRootConfiguration.INSTANCE.getIgnoreParentFilename()), this.boolProperty(it, "dotenv.template.filename.ignore.parent", DefaultRootConfiguration.INSTANCE.getIgnoreParentTemplateFilename()), this.stringProperty(it, "dotenv.filename", DefaultRootConfiguration.INSTANCE.getFilename()), this.stringProperty(it, "dotenv.template.filename", DefaultRootConfiguration.INSTANCE.getTemplateFilename()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Properties gradlePropertiesFromFile(Project $this$gradlePropertiesFromFile) {
        Properties result = new Properties();
        File gradlePropertiesFile = $this$gradlePropertiesFromFile.file((Object)"gradle.properties");
        if (gradlePropertiesFile.exists()) {
            Intrinsics.checkNotNull((Object)gradlePropertiesFile);
            Closeable closeable = new FileInputStream(gradlePropertiesFile);
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl = false;
                result.load(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return result;
    }

    private final String stringProperty(Project $this$stringProperty, String key, String defaultValue) {
        String string;
        if ($this$stringProperty.getProperties().containsKey(key)) {
            Object v = $this$stringProperty.getProperties().get(key);
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            string = (String)v;
        } else {
            string = defaultValue;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean boolProperty(Project $this$boolProperty, String key, boolean defaultValue) {
        boolean bl;
        if ($this$boolProperty.getProperties().containsKey(key)) {
            String value;
            Object v = $this$boolProperty.getProperties().get(key);
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            String string = value = (String)v;
            if (Intrinsics.areEqual((Object)string, (Object)"true")) {
                bl = true;
            } else if (Intrinsics.areEqual((Object)string, (Object)"false")) {
                bl = false;
            } else {
                void $this$boolProperty_u24lambda_u242;
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
                Logger logger = this.logger;
                boolean bl2 = false;
                $this$boolProperty_u24lambda_u242.append("Could not resolve Boolean properties for key " + key + '.');
                $this$boolProperty_u24lambda_u242.append(" Expect should be set \"true\" or \"false\", but was \"" + value + "\". ");
                $this$boolProperty_u24lambda_u242.append(" The plugin uses default value " + defaultValue + '.');
                String string2 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                logger.warn(string2);
                bl = defaultValue;
            }
        } else {
            bl = defaultValue;
        }
        return bl;
    }

    public static final /* synthetic */ RootConfiguration access$createRootConfiguration(ConfigurationResolver $this) {
        return $this.createRootConfiguration();
    }
}

