/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.squeaky.stmt.query;

import co.touchlab.squeaky.dao.SqueakyContext;
import co.touchlab.squeaky.field.FieldType;
import co.touchlab.squeaky.stmt.JoinAlias;
import co.touchlab.squeaky.stmt.query.Between;
import co.touchlab.squeaky.stmt.query.Clause;
import co.touchlab.squeaky.stmt.query.In;
import co.touchlab.squeaky.stmt.query.IsNotNull;
import co.touchlab.squeaky.stmt.query.IsNull;
import co.touchlab.squeaky.stmt.query.SimpleComparison;
import java.sql.SQLException;
import java.util.Collection;

public class QueryFactory {
    private final SqueakyContext squeakyContext;

    public QueryFactory(SqueakyContext squeakyContext, Class c) {
        this.squeakyContext = squeakyContext;
    }

    public Clause eq(JoinAlias c, String columnFieldName, Object value) throws SQLException {
        return this.initOp(c, columnFieldName, value, "=");
    }

    public Clause gt(JoinAlias c, String columnFieldName, Object value) throws SQLException {
        return this.initOp(c, columnFieldName, value, ">");
    }

    public Clause ge(JoinAlias c, String columnFieldName, Object value) throws SQLException {
        return this.initOp(c, columnFieldName, value, ">=");
    }

    public Clause lt(JoinAlias c, String columnFieldName, Object value) throws SQLException {
        return this.initOp(c, columnFieldName, value, "<");
    }

    public Clause le(JoinAlias c, String columnFieldName, Object value) throws SQLException {
        return this.initOp(c, columnFieldName, value, "<=");
    }

    public Clause like(JoinAlias c, String columnFieldName, Object value) throws SQLException {
        return this.initOp(c, columnFieldName, value, "LIKE");
    }

    public Clause ne(JoinAlias c, String columnFieldName, Object value) throws SQLException {
        return this.initOp(c, columnFieldName, value, "<>");
    }

    public Clause in(JoinAlias c, String columnFieldName, Collection<?> objects) throws SQLException {
        FieldType fieldType = this.squeakyContext.findFieldType(c.tableType, columnFieldName);
        return new In(fieldType, objects, true, c);
    }

    public Clause notIn(JoinAlias c, String columnFieldName, Collection<?> objects) throws SQLException {
        FieldType fieldType = this.squeakyContext.findFieldType(c.tableType, columnFieldName);
        return new In(fieldType, objects, false, c);
    }

    public Clause in(JoinAlias c, String columnFieldName, Object ... objects) throws SQLException {
        FieldType fieldType = this.squeakyContext.findFieldType(c.tableType, columnFieldName);
        return new In(fieldType, objects, true, c);
    }

    public Clause notIn(JoinAlias c, String columnFieldName, Object ... objects) throws SQLException {
        FieldType fieldType = this.squeakyContext.findFieldType(c.tableType, columnFieldName);
        return new In(fieldType, objects, false, c);
    }

    public Clause between(JoinAlias c, String columnFieldName, Object low, Object high) throws SQLException {
        FieldType fieldType = this.squeakyContext.findFieldType(c.tableType, columnFieldName);
        return new Between(fieldType, low, high, c);
    }

    public Clause isNull(JoinAlias c, String columnFieldName) throws SQLException {
        return new IsNull(this.squeakyContext.findFieldType(c.tableType, columnFieldName), c);
    }

    public Clause isNotNull(JoinAlias c, String columnFieldName) throws SQLException {
        return new IsNotNull(this.squeakyContext.findFieldType(c.tableType, columnFieldName), c);
    }

    private Clause initOp(JoinAlias joinAlias, String columnFieldName, Object value, String op) throws SQLException {
        FieldType fieldType = this.squeakyContext.findFieldType(joinAlias.tableType, columnFieldName);
        return new SimpleComparison(fieldType, value, op, joinAlias);
    }
}

