/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.squeaky.stmt.query;

import co.touchlab.squeaky.dao.Dao;
import co.touchlab.squeaky.dao.SqueakyContext;
import co.touchlab.squeaky.stmt.JoinAlias;
import co.touchlab.squeaky.stmt.query.Clause;
import co.touchlab.squeaky.stmt.query.ManyClause;
import co.touchlab.squeaky.stmt.query.QueryFactory;
import co.touchlab.squeaky.stmt.query.Queryable;
import java.sql.SQLException;
import java.util.List;

public class Not<T>
implements Clause,
Queryable<T> {
    private final QueryFactory queryFactory;
    private Clause comparison = null;
    private final Queryable<T> parent;
    private final JoinAlias joinAlias;

    public Not(Queryable<T> parent, QueryFactory queryFactory, JoinAlias joinAlias) {
        this.queryFactory = queryFactory;
        this.parent = parent;
        this.joinAlias = joinAlias;
    }

    @Override
    public void appendSql(SqueakyContext squeakyContext, StringBuilder sb, boolean joinsAllowed) throws SQLException {
        if (this.comparison == null) {
            throw new IllegalStateException("Clause has not been set in NOT operation");
        }
        sb.append("(NOT ");
        this.comparison.appendSql(squeakyContext, sb, joinsAllowed);
        sb.append(") ");
    }

    @Override
    public void appendValue(SqueakyContext squeakyContext, List<String> params) throws SQLException {
        this.comparison.appendValue(squeakyContext, params);
    }

    public String toString() {
        if (this.comparison == null) {
            return "NOT without comparison";
        }
        return "NOT comparison " + this.comparison;
    }

    @Override
    public String getWhereStatement(boolean joinsAllowed) throws SQLException {
        throw new SQLException("Must complete NOT statement");
    }

    @Override
    public Dao.QueryModifiers<T> query() throws SQLException {
        throw new SQLException("Must complete NOT statement");
    }

    @Override
    public Queryable<T> reset() {
        return this.parent.reset();
    }

    @Override
    public Queryable<T> eq(String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.eq(this.joinAlias, columnFieldName, value);
        return this.parent;
    }

    @Override
    public Queryable<T> eq(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.eq(joinAlias, columnFieldName, value);
        return this.parent;
    }

    @Override
    public Queryable<T> gt(String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.gt(this.joinAlias, columnFieldName, value);
        return this.parent;
    }

    @Override
    public Queryable<T> gt(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.gt(joinAlias, columnFieldName, value);
        return this.parent;
    }

    @Override
    public Queryable<T> ge(String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.ge(this.joinAlias, columnFieldName, value);
        return this.parent;
    }

    @Override
    public Queryable<T> ge(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.ge(joinAlias, columnFieldName, value);
        return this.parent;
    }

    @Override
    public Queryable<T> lt(String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.lt(this.joinAlias, columnFieldName, value);
        return this.parent;
    }

    @Override
    public Queryable<T> lt(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.lt(joinAlias, columnFieldName, value);
        return this.parent;
    }

    @Override
    public Queryable<T> le(String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.le(this.joinAlias, columnFieldName, value);
        return this.parent;
    }

    @Override
    public Queryable<T> le(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.le(joinAlias, columnFieldName, value);
        return this.parent;
    }

    @Override
    public Queryable<T> like(String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.like(this.joinAlias, columnFieldName, value);
        return this.parent;
    }

    @Override
    public Queryable<T> like(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.like(joinAlias, columnFieldName, value);
        return this.parent;
    }

    @Override
    public Queryable<T> ne(String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.ne(this.joinAlias, columnFieldName, value);
        return this.parent;
    }

    @Override
    public Queryable<T> ne(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.ne(joinAlias, columnFieldName, value);
        return this.parent;
    }

    @Override
    public Queryable<T> in(String columnFieldName, Iterable<?> objects) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.in(this.joinAlias, columnFieldName, objects);
        return this.parent;
    }

    @Override
    public Queryable<T> in(JoinAlias joinAlias, String columnFieldName, Iterable<?> objects) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.in(joinAlias, columnFieldName, objects);
        return this.parent;
    }

    @Override
    public Queryable<T> notIn(String columnFieldName, Iterable<?> objects) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.notIn(this.joinAlias, columnFieldName, objects);
        return this.parent;
    }

    @Override
    public Queryable<T> notIn(JoinAlias joinAlias, String columnFieldName, Iterable<?> objects) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.notIn(joinAlias, columnFieldName, objects);
        return this.parent;
    }

    @Override
    public Queryable<T> in(String columnFieldName, Object ... objects) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.in(this.joinAlias, columnFieldName, objects);
        return this.parent;
    }

    @Override
    public Queryable<T> in(JoinAlias joinAlias, String columnFieldName, Object ... objects) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.in(joinAlias, columnFieldName, objects);
        return this.parent;
    }

    @Override
    public Queryable<T> notIn(String columnFieldName, Object ... objects) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.notIn(this.joinAlias, columnFieldName, objects);
        return this.parent;
    }

    @Override
    public Queryable<T> notIn(JoinAlias joinAlias, String columnFieldName, Object ... objects) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.notIn(joinAlias, columnFieldName, objects);
        return this.parent;
    }

    @Override
    public Queryable<T> between(String columnFieldName, Object low, Object high) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.between(this.joinAlias, columnFieldName, low, high);
        return this.parent;
    }

    @Override
    public Queryable<T> between(JoinAlias joinAlias, String columnFieldName, Object low, Object high) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.between(joinAlias, columnFieldName, low, high);
        return this.parent;
    }

    @Override
    public Queryable<T> isNull(String columnFieldName) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.isNull(this.joinAlias, columnFieldName);
        return this.parent;
    }

    @Override
    public Queryable<T> isNull(JoinAlias joinAlias, String columnFieldName) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.isNull(joinAlias, columnFieldName);
        return this.parent;
    }

    @Override
    public Queryable<T> isNotNull(String columnFieldName) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.isNotNull(this.joinAlias, columnFieldName);
        return this.parent;
    }

    @Override
    public Queryable<T> isNotNull(JoinAlias joinAlias, String columnFieldName) throws SQLException {
        this.checkClause();
        this.comparison = this.queryFactory.isNotNull(joinAlias, columnFieldName);
        return this.parent;
    }

    @Override
    public Queryable<T> and() throws SQLException {
        ManyClause<T> manyClause;
        this.checkClause();
        this.comparison = manyClause = new ManyClause<T>(this.parent, this.queryFactory, "AND", this.joinAlias);
        return manyClause;
    }

    @Override
    public Queryable<T> or() throws SQLException {
        ManyClause<T> manyClause;
        this.checkClause();
        this.comparison = manyClause = new ManyClause<T>(this.parent, this.queryFactory, "OR", this.joinAlias);
        return manyClause;
    }

    @Override
    public Queryable<T> not() throws SQLException {
        throw new SQLException("Double negative? Calling not on not");
    }

    @Override
    public Queryable<T> end() throws SQLException {
        throw new SQLException("Can't end a single entity");
    }

    private void checkClause() throws SQLException {
        if (this.comparison != null) {
            throw new SQLException("Clause already defined. Must use and/or for multiple conditions");
        }
    }
}

