/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.squeaky.table;

import co.touchlab.squeaky.field.FieldType;
import co.touchlab.squeaky.field.FieldsEnum;
import co.touchlab.squeaky.field.ForeignCollectionInfo;
import java.sql.SQLException;

public class TableInfo<T> {
    public final Class<T> dataClass;
    private final String tableName;
    private final FieldType[] fieldTypes;
    private final ForeignCollectionInfo[] foreignCollections;
    public final FieldType idField;

    public TableInfo(Class clazz, String name, FieldsEnum[] fields, ForeignCollectionInfo[] foreignCollections) throws SQLException {
        this.dataClass = clazz;
        this.tableName = name;
        this.fieldTypes = new FieldType[fields.length];
        int i = 0;
        for (FieldsEnum field : fields) {
            this.fieldTypes[i++] = field.getFieldType();
        }
        this.foreignCollections = foreignCollections;
        FieldType findIdFieldType = null;
        for (FieldType fieldType : this.fieldTypes) {
            if (!fieldType.isId() && !fieldType.isGeneratedId()) continue;
            if (findIdFieldType != null) {
                throw new SQLException("More than 1 idField configured for class " + this.dataClass + " (" + findIdFieldType + "," + fieldType + ")");
            }
            findIdFieldType = fieldType;
        }
        this.idField = findIdFieldType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public FieldType[] getFieldTypes() {
        return this.fieldTypes;
    }

    public ForeignCollectionInfo[] getForeignCollections() {
        return this.foreignCollections;
    }
}

