/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.squeaky.field.types;

import co.touchlab.squeaky.field.FieldType;
import co.touchlab.squeaky.field.SqlType;
import co.touchlab.squeaky.field.types.BaseDataType;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class BaseDateType
extends BaseDataType {
    protected static final DateStringFormatConfig defaultDateFormatConfig = new DateStringFormatConfig("yyyy-MM-dd HH:mm:ss.SSSSSS");

    protected BaseDateType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    protected BaseDateType(SqlType sqlType) {
        super(sqlType);
    }

    protected static DateStringFormatConfig convertDateStringConfig(FieldType fieldType, DateStringFormatConfig defaultDateFormatConfig) {
        if (fieldType == null) {
            return defaultDateFormatConfig;
        }
        DateStringFormatConfig configObj = (DateStringFormatConfig)fieldType.getDataTypeConfigObj();
        if (configObj == null) {
            return defaultDateFormatConfig;
        }
        return configObj;
    }

    protected static Date parseDateString(DateStringFormatConfig formatConfig, String dateStr) throws ParseException {
        DateFormat dateFormat = formatConfig.getDateFormat();
        return dateFormat.parse(dateStr);
    }

    protected static String normalizeDateString(DateStringFormatConfig formatConfig, String dateStr) throws ParseException {
        DateFormat dateFormat = formatConfig.getDateFormat();
        Date date = dateFormat.parse(dateStr);
        return dateFormat.format(date);
    }

    protected static class DateStringFormatConfig {
        private final ThreadLocal<DateFormat> threadLocal = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(DateStringFormatConfig.this.dateFormatStr);
            }
        };
        final String dateFormatStr;

        public DateStringFormatConfig(String dateFormatStr) {
            this.dateFormatStr = dateFormatStr;
        }

        public DateFormat getDateFormat() {
            return this.threadLocal.get();
        }

        public String toString() {
            return this.dateFormatStr;
        }
    }
}

