/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.squeaky.dao;

import co.touchlab.squeaky.dao.Dao;
import co.touchlab.squeaky.dao.SqueakyContext;
import co.touchlab.squeaky.field.FieldType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DaoHelper {
    public static Dao.ForeignRefresh[] refresh(String refreshTree) {
        ArrayList<String> parsedFields = new ArrayList<String>();
        int bracketCount = 0;
        int lastBreak = 0;
        for (int i = 0; i < refreshTree.length(); ++i) {
            if (bracketCount == 0 && refreshTree.charAt(i) == ',') {
                String fieldTree = refreshTree.substring(lastBreak, i);
                parsedFields.add(fieldTree.trim());
                lastBreak = i + 1;
                continue;
            }
            if (refreshTree.charAt(i) == '[') {
                ++bracketCount;
                continue;
            }
            if (refreshTree.charAt(i) != ']') continue;
            --bracketCount;
        }
        if (bracketCount != 0) {
            throw new RuntimeException("Bad refresh format " + refreshTree);
        }
        parsedFields.add(refreshTree.substring(lastBreak).trim());
        ArrayList<Dao.ForeignRefresh> refreshs = new ArrayList<Dao.ForeignRefresh>(parsedFields.size());
        for (String parsedField : parsedFields) {
            if (parsedField.contains("[")) {
                int startIndex = parsedField.indexOf(91);
                refreshs.add(new Dao.ForeignRefresh(parsedField.substring(0, startIndex), DaoHelper.refresh(parsedField.substring(startIndex + 1, parsedField.length() - 1))));
                continue;
            }
            refreshs.add(new Dao.ForeignRefresh(parsedField));
        }
        return refreshs.toArray(new Dao.ForeignRefresh[refreshs.size()]);
    }

    public static ValBuilder vals() {
        return new ValBuilder();
    }

    public static Dao.ForeignRefresh findRefresh(Dao.ForeignRefresh[] foreignRefreshs, String fieldName) {
        for (Dao.ForeignRefresh foreignRefresh : foreignRefreshs) {
            if (!foreignRefresh.field.equals(fieldName)) continue;
            return foreignRefresh;
        }
        return null;
    }

    public static Dao.ForeignRefresh[] fillForeignRefreshMap(SqueakyContext squeakyContext, Class type, int count) throws SQLException {
        FieldType[] fieldTypes = squeakyContext.getGeneratedTableMapper(type).getTableConfig().getFieldTypes();
        return DaoHelper.fillForeignRefreshMap(squeakyContext, fieldTypes, count);
    }

    public static Dao.ForeignRefresh[] fillForeignRefreshMap(SqueakyContext squeakyContext, FieldType[] fieldTypes, int count) throws SQLException {
        ArrayList<Dao.ForeignRefresh> foreignRefreshs = new ArrayList<Dao.ForeignRefresh>();
        for (FieldType fieldType : fieldTypes) {
            if (!fieldType.isForeign() || !fieldType.isForeignAutoRefresh()) continue;
            foreignRefreshs.add(new Dao.ForeignRefresh(fieldType.getFieldName(), DaoHelper.fillForeignRefreshMap(squeakyContext, fieldType, count - 1)));
        }
        return foreignRefreshs.size() == 0 ? null : foreignRefreshs.toArray(new Dao.ForeignRefresh[foreignRefreshs.size()]);
    }

    private static Dao.ForeignRefresh[] fillForeignRefreshMap(SqueakyContext squeakyContext, FieldType parentType, int count) throws SQLException {
        if (count == 0) {
            return null;
        }
        FieldType[] fieldTypes = squeakyContext.getGeneratedTableMapper(parentType.getFieldType()).getTableConfig().getFieldTypes();
        return DaoHelper.fillForeignRefreshMap(squeakyContext, fieldTypes, count);
    }

    public static class ValBuilder {
        Map<String, Object> vals = new HashMap<String, Object>();

        public ValBuilder add(String col, Object val) {
            this.vals.put(col, val);
            return this;
        }

        public Map<String, Object> build() {
            return this.vals;
        }
    }
}

