package co.ronash.pushe.analytics.messages.upstream

import co.ronash.pushe.analytics.event.EventAction
import co.ronash.pushe.messages.MessageType
import co.ronash.pushe.messaging.TypedUpstreamMessage
import com.squareup.moshi.Json
import com.squareup.moshi.JsonClass

@JsonClass(generateAdapter = true)
class EventMessage(
        @Json(name = "name") val name: String,
        @Json(name = "action") val action: EventAction,
        @Json(name = "data") val value: String? = null
) : TypedUpstreamMessage<EventMessage>(
    MessageType.Analytics.Upstream.EVENT,
    { EventMessageJsonAdapter(it) })