package co.ronash.pushe.analytics.messages

import co.ronash.pushe.messaging.PostOffice
import co.ronash.pushe.analytics.dagger.AnalyticsScope
import co.ronash.pushe.analytics.goal.GoalProcessManager
import co.ronash.pushe.analytics.messages.downstream.NewGoalMessage
import co.ronash.pushe.analytics.messages.downstream.RemoveGoalMessage
import co.ronash.pushe.analytics.messages.downstream.SessionFragmentFlowConfigMessage
import co.ronash.pushe.analytics.session.SessionFlowManager
import javax.inject.Inject

@AnalyticsScope
class MessageDispatcher @Inject constructor(
    private val postOffice: PostOffice,
    private val goalManager: GoalProcessManager,
    private val sessionFlowManager: SessionFlowManager
) {
    fun listenForMessages() {
        postOffice.mailBox(NewGoalMessage.Parser()) { goalManager.updateGoals(it) }
        postOffice.mailBox(RemoveGoalMessage.Parser()) { goalManager.removeGoals(it) }
        postOffice.mailBox(SessionFragmentFlowConfigMessage.Parser()) { sessionFlowManager.changeSessionFragmentFlowConfig(it) }
    }
}