package co.ronash.pushe.analytics.messages.downstream

import co.ronash.pushe.messaging.DownstreamMessageParser
import co.ronash.pushe.analytics.goal.ActivityReachGoal
import co.ronash.pushe.analytics.goal.ButtonClickGoal
import co.ronash.pushe.analytics.goal.FragmentReachGoal
import co.ronash.pushe.messages.MessageType
import com.squareup.moshi.Json
import com.squareup.moshi.JsonClass

@JsonClass(generateAdapter = true)
class NewGoalMessage (
    @Json(name = "activity") val activityReachGoals: List<ActivityReachGoal>,
    @Json(name = "fragment") val fragmentReachGoals: List<FragmentReachGoal>,
    @Json(name = "button") val buttonClickGoals: List<ButtonClickGoal>
) {
    class Parser : DownstreamMessageParser<NewGoalMessage>(
//         TODO: add a message type for goal passing
        MessageType.Analytics.Downstream.NEW_GOAL,
        { NewGoalMessageJsonAdapter(it) }
    )
}