package co.ronash.pushe.analytics.tasks

import android.content.Context
import androidx.work.ExistingWorkPolicy
import androidx.work.NetworkType
import androidx.work.WorkerParameters
import co.ronash.pushe.Pushe
import co.ronash.pushe.internal.PusheInternals
import co.ronash.pushe.PusheLifecycle
import co.ronash.pushe.analytics.LogTag.T_ANALYTICS
import co.ronash.pushe.analytics.LogTag.T_ANALYTICS_SESSION
import co.ronash.pushe.analytics.dagger.AnalyticsComponent
import co.ronash.pushe.analytics.session.SessionFlowManager
import co.ronash.pushe.internal.ComponentNotAvailableException
import co.ronash.pushe.internal.task.OneTimeTaskOptions
import co.ronash.pushe.internal.task.PusheTask
import co.ronash.pushe.utils.assertCpuThread
import co.ronash.pushe.utils.log.Plog
import io.reactivex.Single
import javax.inject.Inject

class SessionEndDetectorTask(context: Context, workerParameters: WorkerParameters)
    : PusheTask("session_end_detector", context, workerParameters) {

    @Inject lateinit var sessionFlowManager: SessionFlowManager
    @Inject lateinit var pusheLifecycle: PusheLifecycle

    override fun perform(): Single<Result> {
        assertCpuThread()
        val analyticsComponent = PusheInternals.getComponent(AnalyticsComponent::class.java)
            ?: throw ComponentNotAvailableException(Pushe.ANALYTICS)

        analyticsComponent.inject(this)

        if (!pusheLifecycle.isAppOpened) {
            sessionFlowManager.endSession()
        } else {
            Plog[T_ANALYTICS, T_ANALYTICS_SESSION]
                .warn("Session-end detector has been run while app is open, session will not be ended")
        }

        return Single.just(Result.success())
    }

    object Options : OneTimeTaskOptions() {
        override fun networkType() = NetworkType.NOT_REQUIRED
        override fun task() = SessionEndDetectorTask::class
        override fun taskId() = "pushe_session_end_detector"
        override fun existingWorkPolicy() = ExistingWorkPolicy.REPLACE
    }
}


