package co.ronash.pushe.analytics.event;

public class Event {

    private String name;
    private EventAction action;

    private Event(String name, EventAction action) {
        this.name = name;
        this.action = action;
    }

    public String getName() {
        return name;
    }

    public EventAction getAction() {
        return action;
    }

    public static class Builder {
        private String name;
        private EventAction action = EventAction.CUSTOM;

        public Builder(String name) {
            this.name = name;
        }

        public Builder setAction(EventAction action) {
            this.action = action;
            return this;
        }

        public Event build() {
            return new Event(name, action);
        }
    }
}
