package co.ronash.pushe.analytics

import co.ronash.pushe.internal.PusheServiceApi
import co.ronash.pushe.messaging.PostOffice
import co.ronash.pushe.messaging.SendPriority
import co.ronash.pushe.analytics.event.Ecommerce
import co.ronash.pushe.analytics.event.Event
import co.ronash.pushe.analytics.event.EventAction
import co.ronash.pushe.analytics.messages.upstream.EcommerceMessage
import co.ronash.pushe.analytics.messages.upstream.EventMessage
import javax.inject.Inject

class PusheAnalytics @Inject constructor(
        private val postOffice: PostOffice
) : PusheServiceApi {
    fun sendEvent(event: Event) {
        postOffice.sendMessage(
            message = EventMessage(
                event.name,
                event.action.toString()
            ),
            sendPriority = SendPriority.SOON
        )
    }

    fun sendEvent(name: String) {
        postOffice.sendMessage(
            message = EventMessage(
                name,
                EventAction.CUSTOM.toString()
            ),
            sendPriority = SendPriority.SOON
        )
    }

    fun sendEcommerceData(ecommerce: Ecommerce) {
        postOffice.sendMessage(
            message = EcommerceMessage(
                ecommerce.name,
                ecommerce.price,
                ecommerce.category,
                ecommerce.quantity
            ),
            sendPriority = SendPriority.SOON
        )
    }

    fun sendEcommerceData(name: String, price: Double) {
        postOffice.sendMessage(
            message = EcommerceMessage(
                name,
                price,
                null,
                null
            ),
            sendPriority = SendPriority.SOON
        )
    }
}