/*
 * Decompiled with CFR 0.152.
 */
package co.omise.android.api;

import co.omise.android.api.Endpoint;
import co.omise.android.api.Request;
import co.omise.android.models.APIError;
import co.omise.android.models.Model;
import co.omise.android.models.Serializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001b*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006J1\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000e\"\u00020\fH\u0004\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u0012j\u0002`\u00130\u0011H\u0016J\b\u0010\u0014\u001a\u00020\fH\u0016J\b\u0010\u000b\u001a\u00020\bH$J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H$\u00a8\u0006\u001d"}, d2={"Lco/omise/android/api/RequestBuilder;", "T", "Lco/omise/android/models/Model;", "", "()V", "build", "Lco/omise/android/api/Request;", "buildUrl", "Lokhttp3/HttpUrl;", "endpoint", "Lco/omise/android/api/Endpoint;", "path", "", "segments", "", "(Lco/omise/android/api/Endpoint;Ljava/lang/String;[Ljava/lang/String;)Lokhttp3/HttpUrl;", "errorType", "Ljava/lang/Class;", "Ljava/lang/Error;", "Lkotlin/Error;", "method", "payload", "Lokhttp3/RequestBody;", "serialize", "serializer", "Lco/omise/android/models/Serializer;", "type", "Companion", "HttpUrlBuilder", "sdk_productionRelease"})
public abstract class RequestBuilder<T extends Model> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String POST = "POST";
    @NotNull
    public static final String GET = "GET";
    @NotNull
    public static final String PATCH = "PATCH";
    @NotNull
    public static final String DELETE = "DELETE";
    @NotNull
    private static final MediaType JSON_MEDIA_TYPE = MediaType.Companion.get("application/json; charset=utf-8");

    private final Serializer serializer() {
        return new Serializer();
    }

    @NotNull
    public final Request<T> build() {
        RequestBuilder requestBuilder = this;
        String string = requestBuilder.method();
        HttpUrl httpUrl = requestBuilder.path();
        RequestBody requestBody = requestBuilder.payload();
        Class<T> clazz = requestBuilder.type();
        Class<Error> clazz2 = requestBuilder.errorType();
        return new Request<T>(string, httpUrl, requestBody, clazz, clazz2, this);
    }

    @NotNull
    public String method() {
        return GET;
    }

    @NotNull
    protected abstract HttpUrl path();

    @Nullable
    public RequestBody payload() {
        return null;
    }

    @NotNull
    protected abstract Class<T> type();

    @NotNull
    public Class<Error> errorType() {
        return APIError.class;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final HttpUrl buildUrl(@NotNull Endpoint endpoint, @NotNull String path, String ... segments) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)segments, (String)"segments");
        RequestBuilder requestBuilder = list2;
        List list2 = ArraysKt.asList((Object[])var3_3);
        return new HttpUrlBuilder(requestBuilder, (Endpoint)var1_1, (String)var2_2, list2).build();
    }

    @NotNull
    protected final RequestBody serialize() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream(4096);
        this.serializer().serializeRequestBuilder(byteArrayOutputStream2, this);
        byte[] byArray = byteArrayOutputStream2.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"stream.toByteArray()");
        return RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])byArray, (MediaType)JSON_MEDIA_TYPE, (int)0, (int)0, (int)6, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lco/omise/android/api/RequestBuilder$HttpUrlBuilder;", "", "endpoint", "Lco/omise/android/api/Endpoint;", "path", "", "segments", "", "(Lco/omise/android/api/RequestBuilder;Lco/omise/android/api/Endpoint;Ljava/lang/String;Ljava/util/List;)V", "build", "Lokhttp3/HttpUrl;", "sdk_productionRelease"})
    public final class HttpUrlBuilder {
        @NotNull
        private final Endpoint endpoint;
        @NotNull
        private final String path;
        @NotNull
        private final List<String> segments;
        final /* synthetic */ RequestBuilder<T> this$0;

        /*
         * WARNING - void declaration
         */
        public HttpUrlBuilder(@NotNull RequestBuilder this$0, @NotNull Endpoint endpoint, @NotNull String path, List<String> segments) {
            void var1_1;
            void var4_4;
            void var3_3;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"endpoint");
            Intrinsics.checkNotNullParameter((Object)var3_3, (String)"path");
            Intrinsics.checkNotNullParameter((Object)var4_4, (String)"segments");
            this.this$0 = var1_1;
            this.endpoint = var2_2;
            this.path = var3_3;
            this.segments = var4_4;
        }

        @NotNull
        public final HttpUrl build() {
            HttpUrlBuilder httpUrlBuilder = this_;
            Objects.requireNonNull(httpUrlBuilder.endpoint);
            Objects.requireNonNull(httpUrlBuilder.path);
            HttpUrlBuilder this_ = httpUrlBuilder.endpoint.buildUrl().addPathSegment(this_.path);
            for (String string : httpUrlBuilder.segments) {
                if (!(StringsKt.isBlank((CharSequence)string) ^ true)) continue;
                this_.addPathSegment(string);
            }
            return this_.build();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lco/omise/android/api/RequestBuilder$Companion;", "", "()V", "DELETE", "", "GET", "JSON_MEDIA_TYPE", "Lokhttp3/MediaType;", "getJSON_MEDIA_TYPE", "()Lokhttp3/MediaType;", "PATCH", "POST", "sdk_productionRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @NotNull
        public final MediaType getJSON_MEDIA_TYPE() {
            return JSON_MEDIA_TYPE;
        }
    }
}

