/*
 * Decompiled with CFR 0.152.
 */
package co.omise.android;

import co.omise.android.models.CardBrand;

public final class CardNumber {
    public static String normalize(String number) {
        String string;
        if (number == null) {
            return "";
        }
        return string.replaceAll("[^0-9]", "");
    }

    public static String format(String number) {
        StringBuilder stringBuilder;
        CharSequence charSequence;
        if (number == null) {
            return "";
        }
        String string = charSequence;
        charSequence = stringBuilder;
        stringBuilder = new StringBuilder();
        for (char c2 : string.toCharArray()) {
            if ('0' > c2 || c2 > '9') continue;
            if ((((StringBuilder)charSequence).length() - 4) % 5 == 0) {
                ((StringBuilder)charSequence).append(' ');
            }
            ((StringBuilder)charSequence).append(c2);
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static CardBrand brand(String number) {
        String string = CardNumber.normalize(number);
        CardBrand[] cardBrandArray = CardBrand.ALL;
        int n2 = CardBrand.ALL.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CardBrand cardBrand = cardBrandArray[i2];
            if (!cardBrand.match(string)) continue;
            return cardBrand;
        }
        return null;
    }

    public static boolean luhn(String number) {
        int n2;
        char[] cArray = CardNumber.normalize(number).toCharArray();
        Object object = cArray;
        int n3 = cArray.length;
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < ((Object)object).length; ++n2) {
            nArray[n2] = (int)(object[n2] - 48);
        }
        int n4 = 0;
        n2 = 0;
        for (int i2 = n3 - 1; i2 >= 0; i2 -= 2) {
            n4 += nArray[i2];
        }
        n3 -= 2;
        while (n3 >= 0) {
            int n5 = nArray[n3];
            n2 += n5 * 2;
            if (n5 > 4) {
                n2 -= 9;
            }
            n3 -= 2;
        }
        return (n4 + n2) % 10 == 0;
    }
}

