/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging.logback;

import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.encoder.EncoderBase;
import co.elastic.logging.EcsJsonSerializer;
import co.elastic.logging.JsonUtils;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;

public class EcsEncoder
extends EncoderBase<ILoggingEvent> {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private boolean stackTraceAsArray = false;
    private String serviceName;
    private String eventDataset;
    private boolean includeMarkers = false;
    private ThrowableProxyConverter throwableProxyConverter;
    private boolean includeOrigin;
    private List<Pair> additionalFields = new ArrayList<Pair>();

    public byte[] headerBytes() {
        return null;
    }

    public void start() {
        super.start();
        this.throwableProxyConverter = new ThrowableProxyConverter();
        this.throwableProxyConverter.start();
        this.eventDataset = EcsJsonSerializer.computeEventDataset((String)this.eventDataset, (String)this.serviceName);
    }

    public byte[] encode(ILoggingEvent event) {
        IThrowableProxy throwableProxy;
        StackTraceElement[] callerData;
        StringBuilder builder = new StringBuilder();
        EcsJsonSerializer.serializeObjectStart((StringBuilder)builder, (long)event.getTimeStamp());
        EcsJsonSerializer.serializeLogLevel((StringBuilder)builder, (String)event.getLevel().toString());
        EcsJsonSerializer.serializeFormattedMessage((StringBuilder)builder, (String)event.getFormattedMessage());
        this.serializeMarkers(event, builder);
        EcsJsonSerializer.serializeServiceName((StringBuilder)builder, (String)this.serviceName);
        EcsJsonSerializer.serializeEventDataset((StringBuilder)builder, (String)this.eventDataset);
        EcsJsonSerializer.serializeThreadName((StringBuilder)builder, (String)event.getThreadName());
        EcsJsonSerializer.serializeLoggerName((StringBuilder)builder, (String)event.getLoggerName());
        this.serializeAdditionalFields(builder);
        EcsJsonSerializer.serializeMDC((StringBuilder)builder, (Map)event.getMDCPropertyMap());
        if (this.includeOrigin && (callerData = event.getCallerData()) != null && callerData.length > 0) {
            EcsJsonSerializer.serializeOrigin((StringBuilder)builder, (StackTraceElement)callerData[0]);
        }
        if ((throwableProxy = event.getThrowableProxy()) instanceof ThrowableProxy) {
            EcsJsonSerializer.serializeException((StringBuilder)builder, (Throwable)((ThrowableProxy)throwableProxy).getThrowable(), (boolean)this.stackTraceAsArray);
        } else if (throwableProxy != null) {
            EcsJsonSerializer.serializeException((StringBuilder)builder, (String)throwableProxy.getClassName(), (String)throwableProxy.getMessage(), (String)this.throwableProxyConverter.convert(event), (boolean)this.stackTraceAsArray);
        }
        EcsJsonSerializer.serializeObjectEnd((StringBuilder)builder);
        return builder.toString().getBytes(UTF_8);
    }

    private void serializeAdditionalFields(StringBuilder builder) {
        if (!this.additionalFields.isEmpty()) {
            int size = this.additionalFields.size();
            for (int i = 0; i < size; ++i) {
                Pair additionalField = this.additionalFields.get(i);
                if (additionalField.getKey() == null) continue;
                builder.append('\"');
                JsonUtils.quoteAsString((CharSequence)additionalField.getKey(), (StringBuilder)builder);
                builder.append("\":\"");
                JsonUtils.quoteAsString((CharSequence)additionalField.getValue(), (StringBuilder)builder);
                builder.append("\",");
            }
        }
    }

    private void serializeMarkers(ILoggingEvent event, StringBuilder builder) {
        Marker marker = event.getMarker();
        if (this.includeMarkers && marker != null) {
            EcsJsonSerializer.serializeTagStart((StringBuilder)builder);
            this.serializeMarker(builder, marker);
            EcsJsonSerializer.serializeTagEnd((StringBuilder)builder);
        }
    }

    private void serializeMarker(StringBuilder builder, Marker marker) {
        if (marker != null) {
            EcsJsonSerializer.serializeSingleTag((StringBuilder)builder, (String)marker.getName());
            Iterator it = marker.iterator();
            while (it.hasNext()) {
                this.serializeMarker(builder, (Marker)it.next());
            }
        }
    }

    public byte[] footerBytes() {
        return null;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setIncludeMarkers(boolean includeMarkers) {
        this.includeMarkers = includeMarkers;
    }

    public void setStackTraceAsArray(boolean stackTraceAsArray) {
        this.stackTraceAsArray = stackTraceAsArray;
    }

    public void setIncludeOrigin(boolean includeOrigin) {
        this.includeOrigin = includeOrigin;
    }

    public void addAdditionalField(Pair pair) {
        this.additionalFields.add(pair);
    }

    public void setEventDataset(String eventDataset) {
        this.eventDataset = eventDataset;
    }

    public static class Pair {
        private String key;
        private String value = "";

        public Pair() {
        }

        public Pair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

