/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging.log4j;

import co.elastic.logging.AdditionalField;
import co.elastic.logging.EcsJsonSerializer;
import co.elastic.logging.log4j.MdcAccess;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class EcsLayout
extends Layout {
    private static final MdcAccess MDC_ACCESS = MdcAccess.Resolver.resolve();
    private boolean stackTraceAsArray = false;
    private String serviceName;
    private String serviceVersion;
    private String serviceEnvironment;
    private String serviceNodeName;
    private boolean includeOrigin;
    private String eventDataset;
    private List<AdditionalField> additionalFields = new ArrayList<AdditionalField>();

    public String format(LoggingEvent event) {
        ThrowableInformation throwableInformation;
        LocationInfo locationInformation;
        StringBuilder builder = new StringBuilder();
        EcsJsonSerializer.serializeObjectStart((StringBuilder)builder, (long)event.timeStamp);
        EcsJsonSerializer.serializeLogLevel((StringBuilder)builder, (String)event.level.toString());
        EcsJsonSerializer.serializeFormattedMessage((StringBuilder)builder, (String)event.getRenderedMessage());
        EcsJsonSerializer.serializeEcsVersion((StringBuilder)builder);
        EcsJsonSerializer.serializeServiceName((StringBuilder)builder, (String)this.serviceName);
        EcsJsonSerializer.serializeServiceVersion((StringBuilder)builder, (String)this.serviceVersion);
        EcsJsonSerializer.serializeServiceEnvironment((StringBuilder)builder, (String)this.serviceEnvironment);
        EcsJsonSerializer.serializeServiceNodeName((StringBuilder)builder, (String)this.serviceNodeName);
        EcsJsonSerializer.serializeEventDataset((StringBuilder)builder, (String)this.eventDataset);
        EcsJsonSerializer.serializeThreadName((StringBuilder)builder, (String)event.getThreadName());
        EcsJsonSerializer.serializeLoggerName((StringBuilder)builder, (String)event.categoryName);
        EcsJsonSerializer.serializeAdditionalFields((StringBuilder)builder, this.additionalFields);
        EcsJsonSerializer.serializeMDC((StringBuilder)builder, MDC_ACCESS.getMDC(event));
        EcsJsonSerializer.serializeTag((StringBuilder)builder, (String)event.getNDC());
        if (this.includeOrigin && (locationInformation = event.getLocationInformation()) != null) {
            EcsJsonSerializer.serializeOrigin((StringBuilder)builder, (String)locationInformation.getFileName(), (String)locationInformation.getMethodName(), (int)EcsLayout.getLineNumber(locationInformation));
        }
        if ((throwableInformation = event.getThrowableInformation()) != null) {
            EcsJsonSerializer.serializeException((StringBuilder)builder, (Throwable)throwableInformation.getThrowable(), (boolean)this.stackTraceAsArray);
        }
        EcsJsonSerializer.serializeObjectEnd((StringBuilder)builder);
        return builder.toString();
    }

    private static int getLineNumber(LocationInfo locationInformation) {
        int lineNumber = -1;
        String lineNumberString = locationInformation.getLineNumber();
        if (!"?".equals(lineNumberString)) {
            try {
                lineNumber = Integer.parseInt(lineNumberString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return lineNumber;
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void activateOptions() {
        this.eventDataset = EcsJsonSerializer.computeEventDataset((String)this.eventDataset, (String)this.serviceName);
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public void setServiceEnvironment(String serviceEnvironment) {
        this.serviceEnvironment = serviceEnvironment;
    }

    public void setServiceNodeName(String serviceNodeName) {
        this.serviceNodeName = serviceNodeName;
    }

    public void setIncludeOrigin(boolean includeOrigin) {
        this.includeOrigin = includeOrigin;
    }

    public void setStackTraceAsArray(boolean stackTraceAsArray) {
        this.stackTraceAsArray = stackTraceAsArray;
    }

    public void setEventDataset(String eventDataset) {
        this.eventDataset = eventDataset;
    }

    public void setAdditionalField(String additionalField) {
        this.additionalFields.add(AdditionalField.of((String)additionalField));
    }
}

