/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging.jul;

import co.elastic.logging.AdditionalField;
import co.elastic.logging.EcsJsonSerializer;
import co.elastic.logging.jul.MdcSupplier;
import java.util.Collections;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class EcsFormatter
extends Formatter {
    private static final String UNKNOWN_FILE = "<Unknown>";
    private static final MdcSupplier mdcSupplier = MdcSupplier.Resolver.INSTANCE.resolve();
    private boolean stackTraceAsArray;
    private String serviceName;
    private String serviceNodeName;
    private boolean includeOrigin;
    private String eventDataset;
    private List<AdditionalField> additionalFields = Collections.emptyList();

    public EcsFormatter() {
        this.serviceName = this.getProperty("co.elastic.logging.jul.EcsFormatter.serviceName", null);
        this.serviceNodeName = this.getProperty("co.elastic.logging.jul.EcsFormatter.serviceNodeName", null);
        this.includeOrigin = Boolean.getBoolean(this.getProperty("co.elastic.logging.jul.EcsFormatter.includeOrigin", "false"));
        this.stackTraceAsArray = Boolean.getBoolean(this.getProperty("co.elastic.logging.jul.EcsFormatter.stackTraceAsArray", "false"));
        this.eventDataset = this.getProperty("co.elastic.logging.jul.EcsFormatter.eventDataset", null);
        this.eventDataset = EcsJsonSerializer.computeEventDataset((String)this.eventDataset, (String)this.serviceName);
        this.setAdditionalFields(this.getProperty("co.elastic.logging.jul.EcsFormatter.additionalFields", null));
    }

    @Override
    public String format(LogRecord record) {
        Throwable throwableInformation;
        StringBuilder builder = new StringBuilder();
        EcsJsonSerializer.serializeObjectStart((StringBuilder)builder, (long)record.getMillis());
        EcsJsonSerializer.serializeLogLevel((StringBuilder)builder, (String)record.getLevel().getName());
        EcsJsonSerializer.serializeFormattedMessage((StringBuilder)builder, (String)super.formatMessage(record));
        EcsJsonSerializer.serializeEcsVersion((StringBuilder)builder);
        EcsJsonSerializer.serializeAdditionalFields((StringBuilder)builder, this.additionalFields);
        EcsJsonSerializer.serializeMDC((StringBuilder)builder, mdcSupplier.getMDC());
        EcsJsonSerializer.serializeServiceName((StringBuilder)builder, (String)this.serviceName);
        EcsJsonSerializer.serializeServiceNodeName((StringBuilder)builder, (String)this.serviceNodeName);
        EcsJsonSerializer.serializeEventDataset((StringBuilder)builder, (String)this.eventDataset);
        if (Thread.currentThread().getId() == (long)record.getThreadID()) {
            EcsJsonSerializer.serializeThreadName((StringBuilder)builder, (String)Thread.currentThread().getName());
        } else {
            EcsJsonSerializer.serializeThreadId((StringBuilder)builder, (long)record.getThreadID());
        }
        EcsJsonSerializer.serializeLoggerName((StringBuilder)builder, (String)record.getLoggerName());
        if (this.includeOrigin && record.getSourceClassName() != null && record.getSourceMethodName() != null) {
            EcsJsonSerializer.serializeOrigin((StringBuilder)builder, (String)this.buildFileName(record.getSourceClassName()), (String)record.getSourceMethodName(), (int)-1);
        }
        if ((throwableInformation = record.getThrown()) != null) {
            EcsJsonSerializer.serializeException((StringBuilder)builder, (Throwable)throwableInformation, (boolean)this.stackTraceAsArray);
        }
        EcsJsonSerializer.serializeObjectEnd((StringBuilder)builder);
        return builder.toString();
    }

    protected void setIncludeOrigin(boolean includeOrigin) {
        this.includeOrigin = includeOrigin;
    }

    protected void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    protected void setServiceNodeName(String serviceNodeName) {
        this.serviceNodeName = serviceNodeName;
    }

    protected void setStackTraceAsArray(boolean stackTraceAsArray) {
        this.stackTraceAsArray = stackTraceAsArray;
    }

    public void setEventDataset(String eventDataset) {
        this.eventDataset = eventDataset;
    }

    public void setAdditionalFields(String additionalFields) {
        this.additionalFields = AdditionalField.parse((String)additionalFields);
    }

    private String getProperty(String name, String defaultValue) {
        String value = LogManager.getLogManager().getProperty(name);
        value = value == null ? defaultValue : value.trim();
        return value;
    }

    private String buildFileName(String className) {
        String result = UNKNOWN_FILE;
        if (className != null) {
            int classNameStart;
            int fileNameEnd = className.indexOf(36);
            if (fileNameEnd < 0) {
                fileNameEnd = className.length();
            }
            if ((classNameStart = className.lastIndexOf(46)) < fileNameEnd) {
                result = className.substring(classNameStart + 1, fileNameEnd) + ".java";
            }
        }
        return result;
    }
}

