/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging.jboss.logmanager;

import co.elastic.logging.AdditionalField;
import co.elastic.logging.EcsJsonSerializer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.logmanager.ExtFormatter;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.LogManager;

public class EcsFormatter
extends ExtFormatter {
    private String serviceName;
    private String serviceVersion;
    private String serviceNodeName;
    private String eventDataset;
    private List<AdditionalField> additionalFields = Collections.emptyList();
    private boolean includeOrigin;
    private boolean stackTraceAsArray;

    public EcsFormatter() {
        this.serviceName = this.getProperty("co.elastic.logging.jboss.logmanager.EcsFormatter.serviceName", null);
        this.serviceVersion = this.getProperty("co.elastic.logging.jboss.logmanager.EcsFormatter.serviceversion", null);
        this.serviceNodeName = this.getProperty("co.elastic.logging.jboss.logmanager.EcsFormatter.serviceNodeName", null);
        this.eventDataset = this.getProperty("co.elastic.logging.jboss.logmanager.EcsFormatter.eventDataset", null);
        this.eventDataset = EcsJsonSerializer.computeEventDataset((String)this.eventDataset, (String)this.serviceName);
        this.includeOrigin = Boolean.getBoolean(this.getProperty("co.elastic.logging.jboss.logmanager.EcsFormatter.includeOrigin", "false"));
        this.stackTraceAsArray = Boolean.getBoolean(this.getProperty("co.elastic.logging.jboss.logmanager.EcsFormatter.stackTraceAsArray", "false"));
    }

    public String format(ExtLogRecord record) {
        Throwable throwable;
        StringBuilder builder = new StringBuilder();
        EcsJsonSerializer.serializeObjectStart((StringBuilder)builder, (long)record.getMillis());
        EcsJsonSerializer.serializeLogLevel((StringBuilder)builder, (String)record.getLevel().getName());
        EcsJsonSerializer.serializeFormattedMessage((StringBuilder)builder, (String)record.getFormattedMessage());
        EcsJsonSerializer.serializeEcsVersion((StringBuilder)builder);
        EcsJsonSerializer.serializeServiceName((StringBuilder)builder, (String)this.serviceName);
        EcsJsonSerializer.serializeServiceVersion((StringBuilder)builder, (String)this.serviceVersion);
        EcsJsonSerializer.serializeServiceNodeName((StringBuilder)builder, (String)this.serviceNodeName);
        EcsJsonSerializer.serializeEventDataset((StringBuilder)builder, (String)this.eventDataset);
        EcsJsonSerializer.serializeThreadName((StringBuilder)builder, (String)record.getThreadName());
        EcsJsonSerializer.serializeLoggerName((StringBuilder)builder, (String)record.getLoggerName());
        EcsJsonSerializer.serializeAdditionalFields((StringBuilder)builder, this.additionalFields);
        EcsJsonSerializer.serializeMDC((StringBuilder)builder, (Map)record.getMdcCopy());
        String ndc = record.getNdc();
        if (ndc != null && !ndc.isEmpty()) {
            EcsJsonSerializer.serializeTagStart((StringBuilder)builder);
            for (String tag : ndc.split("\\.")) {
                EcsJsonSerializer.serializeSingleTag((StringBuilder)builder, (String)tag);
            }
            EcsJsonSerializer.serializeTagEnd((StringBuilder)builder);
        }
        if (this.includeOrigin && record.getSourceFileName() != null && record.getSourceMethodName() != null) {
            EcsJsonSerializer.serializeOrigin((StringBuilder)builder, (String)record.getSourceFileName(), (String)record.getSourceMethodName(), (int)record.getSourceLineNumber());
        }
        if ((throwable = record.getThrown()) != null) {
            EcsJsonSerializer.serializeException((StringBuilder)builder, (Throwable)throwable, (boolean)this.stackTraceAsArray);
        }
        EcsJsonSerializer.serializeObjectEnd((StringBuilder)builder);
        return builder.toString();
    }

    public void setIncludeOrigin(boolean includeOrigin) {
        this.includeOrigin = includeOrigin;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
        this.eventDataset = EcsJsonSerializer.computeEventDataset((String)this.eventDataset, (String)serviceName);
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public void setServiceNodeName(String serviceNodeName) {
        this.serviceNodeName = serviceNodeName;
    }

    public void setStackTraceAsArray(boolean stackTraceAsArray) {
        this.stackTraceAsArray = stackTraceAsArray;
    }

    public void setEventDataset(String eventDataset) {
        this.eventDataset = eventDataset;
    }

    public void setAdditionalFields(String additionalFields) {
        this.additionalFields = AdditionalField.parse((String)additionalFields);
    }

    private String getProperty(String name, String defaultValue) {
        String value = LogManager.getLogManager().getProperty(name);
        value = value == null ? defaultValue : value.trim();
        return value;
    }
}

