/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform.get_transform_stats;

import co.elastic.clients.elasticsearch._types.HealthStatus;
import co.elastic.clients.elasticsearch.transform.get_transform_stats.TransformHealthIssue;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TransformStatsHealth
implements JsonpSerializable {
    private final HealthStatus status;
    private final List<TransformHealthIssue> issues;
    public static final JsonpDeserializer<TransformStatsHealth> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TransformStatsHealth::setupTransformStatsHealthDeserializer);

    private TransformStatsHealth(Builder builder) {
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.issues = ApiTypeHelper.unmodifiable(builder.issues);
    }

    public static TransformStatsHealth of(Function<Builder, ObjectBuilder<TransformStatsHealth>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final HealthStatus status() {
        return this.status;
    }

    public final List<TransformHealthIssue> issues() {
        return this.issues;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.issues)) {
            generator.writeKey("issues");
            generator.writeStartArray();
            for (TransformHealthIssue item0 : this.issues) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupTransformStatsHealthDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::status, HealthStatus._DESERIALIZER, "status");
        op.add(Builder::issues, JsonpDeserializer.arrayDeserializer(TransformHealthIssue._DESERIALIZER), "issues");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TransformStatsHealth> {
        private HealthStatus status;
        @Nullable
        private List<TransformHealthIssue> issues;

        public Builder() {
        }

        private Builder(TransformStatsHealth instance) {
            this.status = instance.status;
            this.issues = instance.issues;
        }

        public final Builder status(HealthStatus value) {
            this.status = value;
            return this;
        }

        public final Builder issues(List<TransformHealthIssue> list) {
            this.issues = Builder._listAddAll(this.issues, list);
            return this;
        }

        public final Builder issues(TransformHealthIssue value, TransformHealthIssue ... values) {
            this.issues = Builder._listAdd(this.issues, value, values);
            return this;
        }

        public final Builder issues(Function<TransformHealthIssue.Builder, ObjectBuilder<TransformHealthIssue>> fn) {
            return this.issues(fn.apply(new TransformHealthIssue.Builder()).build(), new TransformHealthIssue[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TransformStatsHealth build() {
            this._checkSingleUse();
            return new TransformStatsHealth(this);
        }
    }
}

