/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.tasks;

import co.elastic.clients.elasticsearch.tasks.TaskInfo;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ParentTaskInfo
extends TaskInfo {
    private final List<TaskInfo> children;
    public static final JsonpDeserializer<ParentTaskInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ParentTaskInfo::setupParentTaskInfoDeserializer);

    private ParentTaskInfo(Builder builder) {
        super(builder);
        this.children = ApiTypeHelper.unmodifiable(builder.children);
    }

    public static ParentTaskInfo of(Function<Builder, ObjectBuilder<ParentTaskInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<TaskInfo> children() {
        return this.children;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.children)) {
            generator.writeKey("children");
            generator.writeStartArray();
            for (TaskInfo item0 : this.children) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupParentTaskInfoDeserializer(ObjectDeserializer<Builder> op) {
        TaskInfo.setupTaskInfoDeserializer(op);
        op.add(Builder::children, JsonpDeserializer.arrayDeserializer(TaskInfo._DESERIALIZER), "children");
    }

    public static class Builder
    extends TaskInfo.AbstractBuilder<Builder>
    implements ObjectBuilder<ParentTaskInfo> {
        @Nullable
        private List<TaskInfo> children;

        public Builder() {
        }

        private Builder(ParentTaskInfo instance) {
            this.children = instance.children;
        }

        public final Builder children(List<TaskInfo> list) {
            this.children = Builder._listAddAll(this.children, list);
            return this;
        }

        public final Builder children(TaskInfo value, TaskInfo ... values) {
            this.children = Builder._listAdd(this.children, value, values);
            return this;
        }

        public final Builder children(Function<TaskInfo.Builder, ObjectBuilder<TaskInfo>> fn) {
            return this.children(fn.apply(new TaskInfo.Builder()).build(), new TaskInfo[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ParentTaskInfo build() {
            this._checkSingleUse();
            return new ParentTaskInfo(this);
        }
    }
}

