/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.Repository;
import co.elastic.clients.elasticsearch.snapshot.RepositoryBase;
import co.elastic.clients.elasticsearch.snapshot.RepositoryVariant;
import co.elastic.clients.elasticsearch.snapshot.S3RepositorySettings;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class S3Repository
extends RepositoryBase
implements RepositoryVariant {
    private final S3RepositorySettings settings;
    public static final JsonpDeserializer<S3Repository> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, S3Repository::setupS3RepositoryDeserializer);

    private S3Repository(Builder builder) {
        super(builder);
        this.settings = ApiTypeHelper.requireNonNull(builder.settings, this, "settings");
    }

    public static S3Repository of(Function<Builder, ObjectBuilder<S3Repository>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Repository.Kind _repositoryKind() {
        return Repository.Kind.S3;
    }

    public final S3RepositorySettings settings() {
        return this.settings;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "s3");
        super.serializeInternal(generator, mapper);
        generator.writeKey("settings");
        this.settings.serialize(generator, mapper);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupS3RepositoryDeserializer(ObjectDeserializer<Builder> op) {
        RepositoryBase.setupRepositoryBaseDeserializer(op);
        op.add(Builder::settings, S3RepositorySettings._DESERIALIZER, "settings");
        op.ignore("type");
    }

    public static class Builder
    extends RepositoryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<S3Repository> {
        private S3RepositorySettings settings;

        public Builder() {
        }

        private Builder(S3Repository instance) {
            this.settings = instance.settings;
        }

        public final Builder settings(S3RepositorySettings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<S3RepositorySettings.Builder, ObjectBuilder<S3RepositorySettings>> fn) {
            return this.settings(fn.apply(new S3RepositorySettings.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public S3Repository build() {
            this._checkSingleUse();
            return new S3Repository(this);
        }
    }
}

