/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.suggest_user_profiles;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Hint
implements JsonpSerializable {
    private final List<String> uids;
    private final Map<String, List<String>> labels;
    public static final JsonpDeserializer<Hint> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Hint::setupHintDeserializer);

    private Hint(Builder builder) {
        this.uids = ApiTypeHelper.unmodifiable(builder.uids);
        this.labels = ApiTypeHelper.unmodifiable(builder.labels);
    }

    public static Hint of(Function<Builder, ObjectBuilder<Hint>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> uids() {
        return this.uids;
    }

    public final Map<String, List<String>> labels() {
        return this.labels;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.uids)) {
            generator.writeKey("uids");
            generator.writeStartArray();
            for (String string : this.uids) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.labels)) {
            generator.writeKey("labels");
            generator.writeStartObject();
            for (Map.Entry entry : this.labels.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.writeStartArray();
                if (entry.getValue() != null) {
                    for (String item1 : (List)entry.getValue()) {
                        generator.write(item1);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupHintDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::uids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "uids");
        op.add(Builder::labels, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "labels");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Hint> {
        @Nullable
        private List<String> uids;
        @Nullable
        private Map<String, List<String>> labels;

        public Builder() {
        }

        private Builder(Hint instance) {
            this.uids = instance.uids;
            this.labels = instance.labels;
        }

        public final Builder uids(List<String> list) {
            this.uids = Builder._listAddAll(this.uids, list);
            return this;
        }

        public final Builder uids(String value, String ... values) {
            this.uids = Builder._listAdd(this.uids, value, values);
            return this;
        }

        public final Builder labels(Map<String, List<String>> map) {
            this.labels = Builder._mapPutAll(this.labels, map);
            return this;
        }

        public final Builder labels(String key, List<String> value) {
            this.labels = Builder._mapPut(this.labels, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Hint build() {
            this._checkSingleUse();
            return new Hint(this);
        }
    }
}

