/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SamlAuthenticateResponse
implements JsonpSerializable {
    private final String accessToken;
    private final String username;
    private final int expiresIn;
    private final String refreshToken;
    private final String realm;
    @Nullable
    private final String inResponseTo;
    public static final JsonpDeserializer<SamlAuthenticateResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SamlAuthenticateResponse::setupSamlAuthenticateResponseDeserializer);

    private SamlAuthenticateResponse(Builder builder) {
        this.accessToken = ApiTypeHelper.requireNonNull(builder.accessToken, this, "accessToken");
        this.username = ApiTypeHelper.requireNonNull(builder.username, this, "username");
        this.expiresIn = ApiTypeHelper.requireNonNull(builder.expiresIn, (Object)this, "expiresIn", 0);
        this.refreshToken = ApiTypeHelper.requireNonNull(builder.refreshToken, this, "refreshToken");
        this.realm = ApiTypeHelper.requireNonNull(builder.realm, this, "realm");
        this.inResponseTo = builder.inResponseTo;
    }

    public static SamlAuthenticateResponse of(Function<Builder, ObjectBuilder<SamlAuthenticateResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final String username() {
        return this.username;
    }

    public final int expiresIn() {
        return this.expiresIn;
    }

    public final String refreshToken() {
        return this.refreshToken;
    }

    public final String realm() {
        return this.realm;
    }

    @Nullable
    public final String inResponseTo() {
        return this.inResponseTo;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("access_token");
        generator.write(this.accessToken);
        generator.writeKey("username");
        generator.write(this.username);
        generator.writeKey("expires_in");
        generator.write(this.expiresIn);
        generator.writeKey("refresh_token");
        generator.write(this.refreshToken);
        generator.writeKey("realm");
        generator.write(this.realm);
        if (this.inResponseTo != null) {
            generator.writeKey("in_response_to");
            generator.write(this.inResponseTo);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSamlAuthenticateResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::accessToken, JsonpDeserializer.stringDeserializer(), "access_token");
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
        op.add(Builder::expiresIn, JsonpDeserializer.integerDeserializer(), "expires_in");
        op.add(Builder::refreshToken, JsonpDeserializer.stringDeserializer(), "refresh_token");
        op.add(Builder::realm, JsonpDeserializer.stringDeserializer(), "realm");
        op.add(Builder::inResponseTo, JsonpDeserializer.stringDeserializer(), "in_response_to");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SamlAuthenticateResponse> {
        private String accessToken;
        private String username;
        private Integer expiresIn;
        private String refreshToken;
        private String realm;
        @Nullable
        private String inResponseTo;

        public final Builder accessToken(String value) {
            this.accessToken = value;
            return this;
        }

        public final Builder username(String value) {
            this.username = value;
            return this;
        }

        public final Builder expiresIn(int value) {
            this.expiresIn = value;
            return this;
        }

        public final Builder refreshToken(String value) {
            this.refreshToken = value;
            return this;
        }

        public final Builder realm(String value) {
            this.realm = value;
            return this;
        }

        public final Builder inResponseTo(@Nullable String value) {
            this.inResponseTo = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SamlAuthenticateResponse build() {
            this._checkSingleUse();
            return new SamlAuthenticateResponse(this);
        }
    }
}

