/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.SizeHttpHistogram;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class HttpRouteRequests
implements JsonpSerializable {
    private final long count;
    private final long totalSizeInBytes;
    private final List<SizeHttpHistogram> sizeHistogram;
    public static final JsonpDeserializer<HttpRouteRequests> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HttpRouteRequests::setupHttpRouteRequestsDeserializer);

    private HttpRouteRequests(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0L);
        this.totalSizeInBytes = ApiTypeHelper.requireNonNull(builder.totalSizeInBytes, (Object)this, "totalSizeInBytes", 0L);
        this.sizeHistogram = ApiTypeHelper.unmodifiableRequired(builder.sizeHistogram, (Object)this, "sizeHistogram");
    }

    public static HttpRouteRequests of(Function<Builder, ObjectBuilder<HttpRouteRequests>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final long totalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public final List<SizeHttpHistogram> sizeHistogram() {
        return this.sizeHistogram;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("total_size_in_bytes");
        generator.write(this.totalSizeInBytes);
        if (ApiTypeHelper.isDefined(this.sizeHistogram)) {
            generator.writeKey("size_histogram");
            generator.writeStartArray();
            for (SizeHttpHistogram item0 : this.sizeHistogram) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupHttpRouteRequestsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::totalSizeInBytes, JsonpDeserializer.longDeserializer(), "total_size_in_bytes");
        op.add(Builder::sizeHistogram, JsonpDeserializer.arrayDeserializer(SizeHttpHistogram._DESERIALIZER), "size_histogram");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<HttpRouteRequests> {
        private Long count;
        private Long totalSizeInBytes;
        private List<SizeHttpHistogram> sizeHistogram;

        public Builder() {
        }

        private Builder(HttpRouteRequests instance) {
            this.count = instance.count;
            this.totalSizeInBytes = instance.totalSizeInBytes;
            this.sizeHistogram = instance.sizeHistogram;
        }

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder totalSizeInBytes(long value) {
            this.totalSizeInBytes = value;
            return this;
        }

        public final Builder sizeHistogram(List<SizeHttpHistogram> list) {
            this.sizeHistogram = Builder._listAddAll(this.sizeHistogram, list);
            return this;
        }

        public final Builder sizeHistogram(SizeHttpHistogram value, SizeHttpHistogram ... values) {
            this.sizeHistogram = Builder._listAdd(this.sizeHistogram, value, values);
            return this;
        }

        public final Builder sizeHistogram(Function<SizeHttpHistogram.Builder, ObjectBuilder<SizeHttpHistogram>> fn) {
            return this.sizeHistogram(fn.apply(new SizeHttpHistogram.Builder()).build(), new SizeHttpHistogram[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HttpRouteRequests build() {
            this._checkSingleUse();
            return new HttpRouteRequests(this);
        }
    }
}

