/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.ForecastResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ForecastRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Time duration;
    @Nullable
    private final Time expiresIn;
    private final String jobId;
    @Nullable
    private final String maxModelMemory;
    public static final JsonpDeserializer<ForecastRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ForecastRequest::setupForecastRequestDeserializer);
    public static final Endpoint<ForecastRequest, ForecastResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ForecastRequest, ForecastResponse>("es/ml.forecast", request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/_forecast");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("jobId", request.jobId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, ForecastResponse._DESERIALIZER);

    private ForecastRequest(Builder builder) {
        this.duration = builder.duration;
        this.expiresIn = builder.expiresIn;
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.maxModelMemory = builder.maxModelMemory;
    }

    public static ForecastRequest of(Function<Builder, ObjectBuilder<ForecastRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time duration() {
        return this.duration;
    }

    @Nullable
    public final Time expiresIn() {
        return this.expiresIn;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final String maxModelMemory() {
        return this.maxModelMemory;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.duration != null) {
            generator.writeKey("duration");
            this.duration.serialize(generator, mapper);
        }
        if (this.expiresIn != null) {
            generator.writeKey("expires_in");
            this.expiresIn.serialize(generator, mapper);
        }
        if (this.maxModelMemory != null) {
            generator.writeKey("max_model_memory");
            generator.write(this.maxModelMemory);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupForecastRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::duration, Time._DESERIALIZER, "duration");
        op.add(Builder::expiresIn, Time._DESERIALIZER, "expires_in");
        op.add(Builder::maxModelMemory, JsonpDeserializer.stringDeserializer(), "max_model_memory");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ForecastRequest> {
        @Nullable
        private Time duration;
        @Nullable
        private Time expiresIn;
        private String jobId;
        @Nullable
        private String maxModelMemory;

        public Builder() {
        }

        private Builder(ForecastRequest instance) {
            this.duration = instance.duration;
            this.expiresIn = instance.expiresIn;
            this.jobId = instance.jobId;
            this.maxModelMemory = instance.maxModelMemory;
        }

        public final Builder duration(@Nullable Time value) {
            this.duration = value;
            return this;
        }

        public final Builder duration(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.duration(fn.apply(new Time.Builder()).build());
        }

        public final Builder expiresIn(@Nullable Time value) {
            this.expiresIn = value;
            return this;
        }

        public final Builder expiresIn(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.expiresIn(fn.apply(new Time.Builder()).build());
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder maxModelMemory(@Nullable String value) {
            this.maxModelMemory = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ForecastRequest build() {
            this._checkSingleUse();
            return new ForecastRequest(this);
        }
    }
}

