/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.RunningStateSearchInterval;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DatafeedRunningState
implements JsonpSerializable {
    private final boolean realTimeConfigured;
    private final boolean realTimeRunning;
    @Nullable
    private final RunningStateSearchInterval searchInterval;
    public static final JsonpDeserializer<DatafeedRunningState> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DatafeedRunningState::setupDatafeedRunningStateDeserializer);

    private DatafeedRunningState(Builder builder) {
        this.realTimeConfigured = ApiTypeHelper.requireNonNull(builder.realTimeConfigured, (Object)this, "realTimeConfigured", false);
        this.realTimeRunning = ApiTypeHelper.requireNonNull(builder.realTimeRunning, (Object)this, "realTimeRunning", false);
        this.searchInterval = builder.searchInterval;
    }

    public static DatafeedRunningState of(Function<Builder, ObjectBuilder<DatafeedRunningState>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean realTimeConfigured() {
        return this.realTimeConfigured;
    }

    public final boolean realTimeRunning() {
        return this.realTimeRunning;
    }

    @Nullable
    public final RunningStateSearchInterval searchInterval() {
        return this.searchInterval;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("real_time_configured");
        generator.write(this.realTimeConfigured);
        generator.writeKey("real_time_running");
        generator.write(this.realTimeRunning);
        if (this.searchInterval != null) {
            generator.writeKey("search_interval");
            this.searchInterval.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDatafeedRunningStateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::realTimeConfigured, JsonpDeserializer.booleanDeserializer(), "real_time_configured");
        op.add(Builder::realTimeRunning, JsonpDeserializer.booleanDeserializer(), "real_time_running");
        op.add(Builder::searchInterval, RunningStateSearchInterval._DESERIALIZER, "search_interval");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DatafeedRunningState> {
        private Boolean realTimeConfigured;
        private Boolean realTimeRunning;
        @Nullable
        private RunningStateSearchInterval searchInterval;

        public Builder() {
        }

        private Builder(DatafeedRunningState instance) {
            this.realTimeConfigured = instance.realTimeConfigured;
            this.realTimeRunning = instance.realTimeRunning;
            this.searchInterval = instance.searchInterval;
        }

        public final Builder realTimeConfigured(boolean value) {
            this.realTimeConfigured = value;
            return this;
        }

        public final Builder realTimeRunning(boolean value) {
            this.realTimeRunning = value;
            return this;
        }

        public final Builder searchInterval(@Nullable RunningStateSearchInterval value) {
            this.searchInterval = value;
            return this;
        }

        public final Builder searchInterval(Function<RunningStateSearchInterval.Builder, ObjectBuilder<RunningStateSearchInterval>> fn) {
            return this.searchInterval(fn.apply(new RunningStateSearchInterval.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DatafeedRunningState build() {
            this._checkSingleUse();
            return new DatafeedRunningState(this);
        }
    }
}

