/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest.geo_ip_stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class GeoIpDownloadStatistics
implements JsonpSerializable {
    private final int successfulDownloads;
    private final int failedDownloads;
    private final long totalDownloadTime;
    private final int databasesCount;
    private final int skippedUpdates;
    private final int expiredDatabases;
    public static final JsonpDeserializer<GeoIpDownloadStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoIpDownloadStatistics::setupGeoIpDownloadStatisticsDeserializer);

    private GeoIpDownloadStatistics(Builder builder) {
        this.successfulDownloads = ApiTypeHelper.requireNonNull(builder.successfulDownloads, (Object)this, "successfulDownloads", 0);
        this.failedDownloads = ApiTypeHelper.requireNonNull(builder.failedDownloads, (Object)this, "failedDownloads", 0);
        this.totalDownloadTime = ApiTypeHelper.requireNonNull(builder.totalDownloadTime, (Object)this, "totalDownloadTime", 0L);
        this.databasesCount = ApiTypeHelper.requireNonNull(builder.databasesCount, (Object)this, "databasesCount", 0);
        this.skippedUpdates = ApiTypeHelper.requireNonNull(builder.skippedUpdates, (Object)this, "skippedUpdates", 0);
        this.expiredDatabases = ApiTypeHelper.requireNonNull(builder.expiredDatabases, (Object)this, "expiredDatabases", 0);
    }

    public static GeoIpDownloadStatistics of(Function<Builder, ObjectBuilder<GeoIpDownloadStatistics>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int successfulDownloads() {
        return this.successfulDownloads;
    }

    public final int failedDownloads() {
        return this.failedDownloads;
    }

    public final long totalDownloadTime() {
        return this.totalDownloadTime;
    }

    public final int databasesCount() {
        return this.databasesCount;
    }

    public final int skippedUpdates() {
        return this.skippedUpdates;
    }

    public final int expiredDatabases() {
        return this.expiredDatabases;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("successful_downloads");
        generator.write(this.successfulDownloads);
        generator.writeKey("failed_downloads");
        generator.write(this.failedDownloads);
        generator.writeKey("total_download_time");
        generator.write(this.totalDownloadTime);
        generator.writeKey("databases_count");
        generator.write(this.databasesCount);
        generator.writeKey("skipped_updates");
        generator.write(this.skippedUpdates);
        generator.writeKey("expired_databases");
        generator.write(this.expiredDatabases);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupGeoIpDownloadStatisticsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::successfulDownloads, JsonpDeserializer.integerDeserializer(), "successful_downloads");
        op.add(Builder::failedDownloads, JsonpDeserializer.integerDeserializer(), "failed_downloads");
        op.add(Builder::totalDownloadTime, JsonpDeserializer.longDeserializer(), "total_download_time");
        op.add(Builder::databasesCount, JsonpDeserializer.integerDeserializer(), "databases_count");
        op.add(Builder::skippedUpdates, JsonpDeserializer.integerDeserializer(), "skipped_updates");
        op.add(Builder::expiredDatabases, JsonpDeserializer.integerDeserializer(), "expired_databases");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GeoIpDownloadStatistics> {
        private Integer successfulDownloads;
        private Integer failedDownloads;
        private Long totalDownloadTime;
        private Integer databasesCount;
        private Integer skippedUpdates;
        private Integer expiredDatabases;

        public Builder() {
        }

        private Builder(GeoIpDownloadStatistics instance) {
            this.successfulDownloads = instance.successfulDownloads;
            this.failedDownloads = instance.failedDownloads;
            this.totalDownloadTime = instance.totalDownloadTime;
            this.databasesCount = instance.databasesCount;
            this.skippedUpdates = instance.skippedUpdates;
            this.expiredDatabases = instance.expiredDatabases;
        }

        public final Builder successfulDownloads(int value) {
            this.successfulDownloads = value;
            return this;
        }

        public final Builder failedDownloads(int value) {
            this.failedDownloads = value;
            return this;
        }

        public final Builder totalDownloadTime(long value) {
            this.totalDownloadTime = value;
            return this;
        }

        public final Builder databasesCount(int value) {
            this.databasesCount = value;
            return this;
        }

        public final Builder skippedUpdates(int value) {
            this.skippedUpdates = value;
            return this;
        }

        public final Builder expiredDatabases(int value) {
            this.expiredDatabases = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoIpDownloadStatistics build() {
            this._checkSingleUse();
            return new GeoIpDownloadStatistics(this);
        }
    }
}

