/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GeoIpProcessor
extends ProcessorBase
implements ProcessorVariant {
    @Nullable
    private final String databaseFile;
    private final String field;
    @Nullable
    private final Boolean firstOnly;
    @Nullable
    private final Boolean ignoreMissing;
    private final List<String> properties;
    @Nullable
    private final String targetField;
    @Nullable
    private final Boolean downloadDatabaseOnPipelineCreation;
    public static final JsonpDeserializer<GeoIpProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoIpProcessor::setupGeoIpProcessorDeserializer);

    private GeoIpProcessor(Builder builder) {
        super(builder);
        this.databaseFile = builder.databaseFile;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.firstOnly = builder.firstOnly;
        this.ignoreMissing = builder.ignoreMissing;
        this.properties = ApiTypeHelper.unmodifiable(builder.properties);
        this.targetField = builder.targetField;
        this.downloadDatabaseOnPipelineCreation = builder.downloadDatabaseOnPipelineCreation;
    }

    public static GeoIpProcessor of(Function<Builder, ObjectBuilder<GeoIpProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Geoip;
    }

    @Nullable
    public final String databaseFile() {
        return this.databaseFile;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean firstOnly() {
        return this.firstOnly;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    public final List<String> properties() {
        return this.properties;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Nullable
    public final Boolean downloadDatabaseOnPipelineCreation() {
        return this.downloadDatabaseOnPipelineCreation;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.databaseFile != null) {
            generator.writeKey("database_file");
            generator.write(this.databaseFile);
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.firstOnly != null) {
            generator.writeKey("first_only");
            generator.write(this.firstOnly.booleanValue());
        }
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.properties)) {
            generator.writeKey("properties");
            generator.writeStartArray();
            for (String item0 : this.properties) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
        if (this.downloadDatabaseOnPipelineCreation != null) {
            generator.writeKey("download_database_on_pipeline_creation");
            generator.write(this.downloadDatabaseOnPipelineCreation.booleanValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupGeoIpProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::databaseFile, JsonpDeserializer.stringDeserializer(), "database_file");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::firstOnly, JsonpDeserializer.booleanDeserializer(), "first_only");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::properties, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "properties");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
        op.add(Builder::downloadDatabaseOnPipelineCreation, JsonpDeserializer.booleanDeserializer(), "download_database_on_pipeline_creation");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoIpProcessor> {
        @Nullable
        private String databaseFile;
        private String field;
        @Nullable
        private Boolean firstOnly;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private List<String> properties;
        @Nullable
        private String targetField;
        @Nullable
        private Boolean downloadDatabaseOnPipelineCreation;

        public Builder() {
        }

        private Builder(GeoIpProcessor instance) {
            this.databaseFile = instance.databaseFile;
            this.field = instance.field;
            this.firstOnly = instance.firstOnly;
            this.ignoreMissing = instance.ignoreMissing;
            this.properties = instance.properties;
            this.targetField = instance.targetField;
            this.downloadDatabaseOnPipelineCreation = instance.downloadDatabaseOnPipelineCreation;
        }

        public final Builder databaseFile(@Nullable String value) {
            this.databaseFile = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder firstOnly(@Nullable Boolean value) {
            this.firstOnly = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public final Builder properties(List<String> list) {
            this.properties = Builder._listAddAll(this.properties, list);
            return this;
        }

        public final Builder properties(String value, String ... values) {
            this.properties = Builder._listAdd(this.properties, value, values);
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        public final Builder downloadDatabaseOnPipelineCreation(@Nullable Boolean value) {
            this.downloadDatabaseOnPipelineCreation = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoIpProcessor build() {
            this._checkSingleUse();
            return new GeoIpProcessor(this);
        }
    }
}

