/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ThinkingConfig
implements JsonpSerializable {
    @Nullable
    private final Integer thinkingBudget;
    public static final JsonpDeserializer<ThinkingConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ThinkingConfig::setupThinkingConfigDeserializer);

    private ThinkingConfig(Builder builder) {
        this.thinkingBudget = builder.thinkingBudget;
    }

    public static ThinkingConfig of(Function<Builder, ObjectBuilder<ThinkingConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer thinkingBudget() {
        return this.thinkingBudget;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.thinkingBudget != null) {
            generator.writeKey("thinking_budget");
            generator.write(this.thinkingBudget.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupThinkingConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::thinkingBudget, JsonpDeserializer.integerDeserializer(), "thinking_budget");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ThinkingConfig> {
        @Nullable
        private Integer thinkingBudget;

        public Builder() {
        }

        private Builder(ThinkingConfig instance) {
            this.thinkingBudget = instance.thinkingBudget;
        }

        public final Builder thinkingBudget(@Nullable Integer value) {
            this.thinkingBudget = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ThinkingConfig build() {
            this._checkSingleUse();
            return new ThinkingConfig(this);
        }
    }
}

