/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.RerankResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RerankRequest
extends RequestBase
implements JsonpSerializable {
    private final String inferenceId;
    private final List<String> input;
    private final String query;
    @Nullable
    private final Boolean returnDocuments;
    @Nullable
    private final JsonData taskSettings;
    @Nullable
    private final Time timeout;
    @Nullable
    private final Integer topN;
    public static final JsonpDeserializer<RerankRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RerankRequest::setupRerankRequestDeserializer);
    public static final Endpoint<RerankRequest, RerankResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RerankRequest, RerankResponse>("es/inference.rerank", request -> "POST", request -> {
        boolean _inferenceId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/rerank");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.inferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _inferenceId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("inferenceId", request.inferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, RerankResponse._DESERIALIZER);

    private RerankRequest(Builder builder) {
        this.inferenceId = ApiTypeHelper.requireNonNull(builder.inferenceId, this, "inferenceId");
        this.input = ApiTypeHelper.unmodifiableRequired(builder.input, (Object)this, "input");
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.returnDocuments = builder.returnDocuments;
        this.taskSettings = builder.taskSettings;
        this.timeout = builder.timeout;
        this.topN = builder.topN;
    }

    public static RerankRequest of(Function<Builder, ObjectBuilder<RerankRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String inferenceId() {
        return this.inferenceId;
    }

    public final List<String> input() {
        return this.input;
    }

    public final String query() {
        return this.query;
    }

    @Nullable
    public final Boolean returnDocuments() {
        return this.returnDocuments;
    }

    @Nullable
    public final JsonData taskSettings() {
        return this.taskSettings;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final Integer topN() {
        return this.topN;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.input)) {
            generator.writeKey("input");
            generator.writeStartArray();
            for (String item0 : this.input) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.returnDocuments != null) {
            generator.writeKey("return_documents");
            generator.write(this.returnDocuments.booleanValue());
        }
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
        if (this.topN != null) {
            generator.writeKey("top_n");
            generator.write(this.topN.intValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRerankRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::input, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "input");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::returnDocuments, JsonpDeserializer.booleanDeserializer(), "return_documents");
        op.add(Builder::taskSettings, JsonData._DESERIALIZER, "task_settings");
        op.add(Builder::topN, JsonpDeserializer.integerDeserializer(), "top_n");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RerankRequest> {
        private String inferenceId;
        private List<String> input;
        private String query;
        @Nullable
        private Boolean returnDocuments;
        @Nullable
        private JsonData taskSettings;
        @Nullable
        private Time timeout;
        @Nullable
        private Integer topN;

        public Builder() {
        }

        private Builder(RerankRequest instance) {
            this.inferenceId = instance.inferenceId;
            this.input = instance.input;
            this.query = instance.query;
            this.returnDocuments = instance.returnDocuments;
            this.taskSettings = instance.taskSettings;
            this.timeout = instance.timeout;
            this.topN = instance.topN;
        }

        public final Builder inferenceId(String value) {
            this.inferenceId = value;
            return this;
        }

        public final Builder input(List<String> list) {
            this.input = Builder._listAddAll(this.input, list);
            return this;
        }

        public final Builder input(String value, String ... values) {
            this.input = Builder._listAdd(this.input, value, values);
            return this;
        }

        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        public final Builder returnDocuments(@Nullable Boolean value) {
            this.returnDocuments = value;
            return this;
        }

        public final Builder taskSettings(@Nullable JsonData value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder topN(@Nullable Integer value) {
            this.topN = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RerankRequest build() {
            this._checkSingleUse();
            return new RerankRequest(this);
        }
    }
}

