/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.inference.CustomServiceSettings;
import co.elastic.clients.elasticsearch.inference.CustomServiceType;
import co.elastic.clients.elasticsearch.inference.CustomTaskSettings;
import co.elastic.clients.elasticsearch.inference.CustomTaskType;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.PutCustomResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutCustomRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final String customInferenceId;
    private final CustomServiceType service;
    private final CustomServiceSettings serviceSettings;
    @Nullable
    private final CustomTaskSettings taskSettings;
    private final CustomTaskType taskType;
    public static final JsonpDeserializer<PutCustomRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutCustomRequest::setupPutCustomRequestDeserializer);
    public static final Endpoint<PutCustomRequest, PutCustomResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutCustomRequest, PutCustomResponse>("es/inference.put_custom", request -> "PUT", request -> {
        boolean _taskType = true;
        int _customInferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.customInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _taskType = true;
        int _customInferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("customInferenceId", request.customInferenceId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutCustomResponse._DESERIALIZER);

    private PutCustomRequest(Builder builder) {
        this.chunkingSettings = builder.chunkingSettings;
        this.customInferenceId = ApiTypeHelper.requireNonNull(builder.customInferenceId, this, "customInferenceId");
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskSettings = builder.taskSettings;
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
    }

    public static PutCustomRequest of(Function<Builder, ObjectBuilder<PutCustomRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final String customInferenceId() {
        return this.customInferenceId;
    }

    public final CustomServiceType service() {
        return this.service;
    }

    public final CustomServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    @Nullable
    public final CustomTaskSettings taskSettings() {
        return this.taskSettings;
    }

    public final CustomTaskType taskType() {
        return this.taskType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutCustomRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, CustomServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, CustomServiceSettings._DESERIALIZER, "service_settings");
        op.add(Builder::taskSettings, CustomTaskSettings._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutCustomRequest> {
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private String customInferenceId;
        private CustomServiceType service;
        private CustomServiceSettings serviceSettings;
        @Nullable
        private CustomTaskSettings taskSettings;
        private CustomTaskType taskType;

        public Builder() {
        }

        private Builder(PutCustomRequest instance) {
            this.chunkingSettings = instance.chunkingSettings;
            this.customInferenceId = instance.customInferenceId;
            this.service = instance.service;
            this.serviceSettings = instance.serviceSettings;
            this.taskSettings = instance.taskSettings;
            this.taskType = instance.taskType;
        }

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder customInferenceId(String value) {
            this.customInferenceId = value;
            return this;
        }

        public final Builder service(CustomServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(CustomServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<CustomServiceSettings.Builder, ObjectBuilder<CustomServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new CustomServiceSettings.Builder()).build());
        }

        public final Builder taskSettings(@Nullable CustomTaskSettings value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder taskSettings(Function<CustomTaskSettings.Builder, ObjectBuilder<CustomTaskSettings>> fn) {
            return this.taskSettings(fn.apply(new CustomTaskSettings.Builder()).build());
        }

        public final Builder taskType(CustomTaskType value) {
            this.taskType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutCustomRequest build() {
            this._checkSingleUse();
            return new PutCustomRequest(this);
        }
    }
}

