/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.ContextualAIServiceSettings;
import co.elastic.clients.elasticsearch.inference.ContextualAIServiceType;
import co.elastic.clients.elasticsearch.inference.ContextualAITaskSettings;
import co.elastic.clients.elasticsearch.inference.PutContextualaiResponse;
import co.elastic.clients.elasticsearch.inference.TaskTypeContextualAI;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutContextualaiRequest
extends RequestBase
implements JsonpSerializable {
    private final String contextualaiInferenceId;
    private final ContextualAIServiceType service;
    private final ContextualAIServiceSettings serviceSettings;
    @Nullable
    private final ContextualAITaskSettings taskSettings;
    private final TaskTypeContextualAI taskType;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutContextualaiRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutContextualaiRequest::setupPutContextualaiRequestDeserializer);
    public static final Endpoint<PutContextualaiRequest, PutContextualaiResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutContextualaiRequest, PutContextualaiResponse>("es/inference.put_contextualai", request -> "PUT", request -> {
        boolean _contextualaiInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.contextualaiInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _contextualaiInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("contextualaiInferenceId", request.contextualaiInferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutContextualaiResponse._DESERIALIZER);

    private PutContextualaiRequest(Builder builder) {
        this.contextualaiInferenceId = ApiTypeHelper.requireNonNull(builder.contextualaiInferenceId, this, "contextualaiInferenceId");
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskSettings = builder.taskSettings;
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
        this.timeout = builder.timeout;
    }

    public static PutContextualaiRequest of(Function<Builder, ObjectBuilder<PutContextualaiRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String contextualaiInferenceId() {
        return this.contextualaiInferenceId;
    }

    public final ContextualAIServiceType service() {
        return this.service;
    }

    public final ContextualAIServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    @Nullable
    public final ContextualAITaskSettings taskSettings() {
        return this.taskSettings;
    }

    public final TaskTypeContextualAI taskType() {
        return this.taskType;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutContextualaiRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::service, ContextualAIServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, ContextualAIServiceSettings._DESERIALIZER, "service_settings");
        op.add(Builder::taskSettings, ContextualAITaskSettings._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutContextualaiRequest> {
        private String contextualaiInferenceId;
        private ContextualAIServiceType service;
        private ContextualAIServiceSettings serviceSettings;
        @Nullable
        private ContextualAITaskSettings taskSettings;
        private TaskTypeContextualAI taskType;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(PutContextualaiRequest instance) {
            this.contextualaiInferenceId = instance.contextualaiInferenceId;
            this.service = instance.service;
            this.serviceSettings = instance.serviceSettings;
            this.taskSettings = instance.taskSettings;
            this.taskType = instance.taskType;
            this.timeout = instance.timeout;
        }

        public final Builder contextualaiInferenceId(String value) {
            this.contextualaiInferenceId = value;
            return this;
        }

        public final Builder service(ContextualAIServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(ContextualAIServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<ContextualAIServiceSettings.Builder, ObjectBuilder<ContextualAIServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new ContextualAIServiceSettings.Builder()).build());
        }

        public final Builder taskSettings(@Nullable ContextualAITaskSettings value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder taskSettings(Function<ContextualAITaskSettings.Builder, ObjectBuilder<ContextualAITaskSettings>> fn) {
            return this.taskSettings(fn.apply(new ContextualAITaskSettings.Builder()).build());
        }

        public final Builder taskType(TaskTypeContextualAI value) {
            this.taskType = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutContextualaiRequest build() {
            this._checkSingleUse();
            return new PutContextualaiRequest(this);
        }
    }
}

