/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.ThinkingConfig;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GoogleVertexAITaskSettings
implements JsonpSerializable {
    @Nullable
    private final Boolean autoTruncate;
    @Nullable
    private final Integer topN;
    @Nullable
    private final ThinkingConfig thinkingConfig;
    @Nullable
    private final Integer maxTokens;
    public static final JsonpDeserializer<GoogleVertexAITaskSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GoogleVertexAITaskSettings::setupGoogleVertexAITaskSettingsDeserializer);

    private GoogleVertexAITaskSettings(Builder builder) {
        this.autoTruncate = builder.autoTruncate;
        this.topN = builder.topN;
        this.thinkingConfig = builder.thinkingConfig;
        this.maxTokens = builder.maxTokens;
    }

    public static GoogleVertexAITaskSettings of(Function<Builder, ObjectBuilder<GoogleVertexAITaskSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean autoTruncate() {
        return this.autoTruncate;
    }

    @Nullable
    public final Integer topN() {
        return this.topN;
    }

    @Nullable
    public final ThinkingConfig thinkingConfig() {
        return this.thinkingConfig;
    }

    @Nullable
    public final Integer maxTokens() {
        return this.maxTokens;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.autoTruncate != null) {
            generator.writeKey("auto_truncate");
            generator.write(this.autoTruncate.booleanValue());
        }
        if (this.topN != null) {
            generator.writeKey("top_n");
            generator.write(this.topN.intValue());
        }
        if (this.thinkingConfig != null) {
            generator.writeKey("thinking_config");
            this.thinkingConfig.serialize(generator, mapper);
        }
        if (this.maxTokens != null) {
            generator.writeKey("max_tokens");
            generator.write(this.maxTokens.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupGoogleVertexAITaskSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::autoTruncate, JsonpDeserializer.booleanDeserializer(), "auto_truncate");
        op.add(Builder::topN, JsonpDeserializer.integerDeserializer(), "top_n");
        op.add(Builder::thinkingConfig, ThinkingConfig._DESERIALIZER, "thinking_config");
        op.add(Builder::maxTokens, JsonpDeserializer.integerDeserializer(), "max_tokens");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GoogleVertexAITaskSettings> {
        @Nullable
        private Boolean autoTruncate;
        @Nullable
        private Integer topN;
        @Nullable
        private ThinkingConfig thinkingConfig;
        @Nullable
        private Integer maxTokens;

        public Builder() {
        }

        private Builder(GoogleVertexAITaskSettings instance) {
            this.autoTruncate = instance.autoTruncate;
            this.topN = instance.topN;
            this.thinkingConfig = instance.thinkingConfig;
            this.maxTokens = instance.maxTokens;
        }

        public final Builder autoTruncate(@Nullable Boolean value) {
            this.autoTruncate = value;
            return this;
        }

        public final Builder topN(@Nullable Integer value) {
            this.topN = value;
            return this;
        }

        public final Builder thinkingConfig(@Nullable ThinkingConfig value) {
            this.thinkingConfig = value;
            return this;
        }

        public final Builder thinkingConfig(Function<ThinkingConfig.Builder, ObjectBuilder<ThinkingConfig>> fn) {
            return this.thinkingConfig(fn.apply(new ThinkingConfig.Builder()).build());
        }

        public final Builder maxTokens(@Nullable Integer value) {
            this.maxTokens = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GoogleVertexAITaskSettings build() {
            this._checkSingleUse();
            return new GoogleVertexAITaskSettings(this);
        }
    }
}

