/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.shard_stores;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ShardStoreNode
implements JsonpSerializable {
    private final Map<String, String> attributes;
    @Nullable
    private final String ephemeralId;
    @Nullable
    private final String externalId;
    private final String name;
    private final List<String> roles;
    private final String transportAddress;
    public static final JsonpDeserializer<ShardStoreNode> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardStoreNode::setupShardStoreNodeDeserializer);

    private ShardStoreNode(Builder builder) {
        this.attributes = ApiTypeHelper.unmodifiableRequired(builder.attributes, (Object)this, "attributes");
        this.ephemeralId = builder.ephemeralId;
        this.externalId = builder.externalId;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.roles = ApiTypeHelper.unmodifiableRequired(builder.roles, (Object)this, "roles");
        this.transportAddress = ApiTypeHelper.requireNonNull(builder.transportAddress, this, "transportAddress");
    }

    public static ShardStoreNode of(Function<Builder, ObjectBuilder<ShardStoreNode>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    @Nullable
    public final String ephemeralId() {
        return this.ephemeralId;
    }

    @Nullable
    public final String externalId() {
        return this.externalId;
    }

    public final String name() {
        return this.name;
    }

    public final List<String> roles() {
        return this.roles;
    }

    public final String transportAddress() {
        return this.transportAddress;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartObject();
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.ephemeralId != null) {
            generator.writeKey("ephemeral_id");
            generator.write(this.ephemeralId);
        }
        if (this.externalId != null) {
            generator.writeKey("external_id");
            generator.write(this.externalId);
        }
        generator.writeKey("name");
        generator.write(this.name);
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (String string : this.roles) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupShardStoreNodeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::ephemeralId, JsonpDeserializer.stringDeserializer(), "ephemeral_id");
        op.add(Builder::externalId, JsonpDeserializer.stringDeserializer(), "external_id");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles");
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardStoreNode> {
        private Map<String, String> attributes;
        @Nullable
        private String ephemeralId;
        @Nullable
        private String externalId;
        private String name;
        private List<String> roles;
        private String transportAddress;

        public Builder() {
        }

        private Builder(ShardStoreNode instance) {
            this.attributes = instance.attributes;
            this.ephemeralId = instance.ephemeralId;
            this.externalId = instance.externalId;
            this.name = instance.name;
            this.roles = instance.roles;
            this.transportAddress = instance.transportAddress;
        }

        public final Builder attributes(Map<String, String> map) {
            this.attributes = Builder._mapPutAll(this.attributes, map);
            return this;
        }

        public final Builder attributes(String key, String value) {
            this.attributes = Builder._mapPut(this.attributes, key, value);
            return this;
        }

        public final Builder ephemeralId(@Nullable String value) {
            this.ephemeralId = value;
            return this;
        }

        public final Builder externalId(@Nullable String value) {
            this.externalId = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder roles(List<String> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        public final Builder roles(String value, String ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        public final Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardStoreNode build() {
            this._checkSingleUse();
            return new ShardStoreNode(this);
        }
    }
}

