/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.shard_stores;

import co.elastic.clients.elasticsearch.indices.shard_stores.ShardStoreAllocation;
import co.elastic.clients.elasticsearch.indices.shard_stores.ShardStoreException;
import co.elastic.clients.elasticsearch.indices.shard_stores.ShardStoreNode;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ShardStore
implements JsonpSerializable {
    private final String nodeId;
    private final ShardStoreNode node;
    private final ShardStoreAllocation allocation;
    @Nullable
    private final String allocationId;
    @Nullable
    private final ShardStoreException storeException;
    public static final JsonpDeserializer<ShardStore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardStore::setupShardStoreDeserializer);

    private ShardStore(Builder builder) {
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
        this.allocation = ApiTypeHelper.requireNonNull(builder.allocation, this, "allocation");
        this.allocationId = builder.allocationId;
        this.storeException = builder.storeException;
    }

    public static ShardStore of(Function<Builder, ObjectBuilder<ShardStore>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final ShardStoreNode node() {
        return this.node;
    }

    public final ShardStoreAllocation allocation() {
        return this.allocation;
    }

    @Nullable
    public final String allocationId() {
        return this.allocationId;
    }

    @Nullable
    public final ShardStoreException storeException() {
        return this.storeException;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey(this.nodeId);
        this.node.serialize(generator, mapper);
        generator.writeKey("allocation");
        this.allocation.serialize(generator, mapper);
        if (this.allocationId != null) {
            generator.writeKey("allocation_id");
            generator.write(this.allocationId);
        }
        if (this.storeException != null) {
            generator.writeKey("store_exception");
            this.storeException.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupShardStoreDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allocation, ShardStoreAllocation._DESERIALIZER, "allocation");
        op.add(Builder::allocationId, JsonpDeserializer.stringDeserializer(), "allocation_id");
        op.add(Builder::storeException, ShardStoreException._DESERIALIZER, "store_exception");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.nodeId((String)name);
            builder.node(ShardStoreNode._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardStore> {
        private String nodeId;
        private ShardStoreNode node;
        private ShardStoreAllocation allocation;
        @Nullable
        private String allocationId;
        @Nullable
        private ShardStoreException storeException;

        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public final Builder node(ShardStoreNode value) {
            this.node = value;
            return this;
        }

        public final Builder node(Function<ShardStoreNode.Builder, ObjectBuilder<ShardStoreNode>> fn) {
            return this.node(fn.apply(new ShardStoreNode.Builder()).build());
        }

        public Builder() {
        }

        private Builder(ShardStore instance) {
            this.allocation = instance.allocation;
            this.allocationId = instance.allocationId;
            this.storeException = instance.storeException;
        }

        public final Builder allocation(ShardStoreAllocation value) {
            this.allocation = value;
            return this;
        }

        public final Builder allocationId(@Nullable String value) {
            this.allocationId = value;
            return this;
        }

        public final Builder storeException(@Nullable ShardStoreException value) {
            this.storeException = value;
            return this;
        }

        public final Builder storeException(Function<ShardStoreException.Builder, ObjectBuilder<ShardStoreException>> fn) {
            return this.storeException(fn.apply(new ShardStoreException.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardStore build() {
            this._checkSingleUse();
            return new ShardStore(this);
        }
    }
}

