/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.segments;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ShardSegmentRouting
implements JsonpSerializable {
    private final String node;
    private final boolean primary;
    private final String state;
    public static final JsonpDeserializer<ShardSegmentRouting> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardSegmentRouting::setupShardSegmentRoutingDeserializer);

    private ShardSegmentRouting(Builder builder) {
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
        this.primary = ApiTypeHelper.requireNonNull(builder.primary, (Object)this, "primary", false);
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
    }

    public static ShardSegmentRouting of(Function<Builder, ObjectBuilder<ShardSegmentRouting>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String node() {
        return this.node;
    }

    public final boolean primary() {
        return this.primary;
    }

    public final String state() {
        return this.state;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node");
        generator.write(this.node);
        generator.writeKey("primary");
        generator.write(this.primary);
        generator.writeKey("state");
        generator.write(this.state);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupShardSegmentRoutingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node");
        op.add(Builder::primary, JsonpDeserializer.booleanDeserializer(), "primary");
        op.add(Builder::state, JsonpDeserializer.stringDeserializer(), "state");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardSegmentRouting> {
        private String node;
        private Boolean primary;
        private String state;

        public Builder() {
        }

        private Builder(ShardSegmentRouting instance) {
            this.node = instance.node;
            this.primary = instance.primary;
            this.state = instance.state;
        }

        public final Builder node(String value) {
            this.node = value;
            return this;
        }

        public final Builder primary(boolean value) {
            this.primary = value;
            return this;
        }

        public final Builder state(String value) {
            this.state = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardSegmentRouting build() {
            this._checkSingleUse();
            return new ShardSegmentRouting(this);
        }
    }
}

