/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.recovery;

import co.elastic.clients.elasticsearch.indices.recovery.ShardRecovery;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class RecoveryStatus
implements JsonpSerializable {
    private final List<ShardRecovery> shards;
    public static final JsonpDeserializer<RecoveryStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RecoveryStatus::setupRecoveryStatusDeserializer);

    private RecoveryStatus(Builder builder) {
        this.shards = ApiTypeHelper.unmodifiableRequired(builder.shards, (Object)this, "shards");
    }

    public static RecoveryStatus of(Function<Builder, ObjectBuilder<RecoveryStatus>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ShardRecovery> shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.shards)) {
            generator.writeKey("shards");
            generator.writeStartArray();
            for (ShardRecovery item0 : this.shards) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRecoveryStatusDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::shards, JsonpDeserializer.arrayDeserializer(ShardRecovery._DESERIALIZER), "shards");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RecoveryStatus> {
        private List<ShardRecovery> shards;

        public Builder() {
        }

        private Builder(RecoveryStatus instance) {
            this.shards = instance.shards;
        }

        public final Builder shards(List<ShardRecovery> list) {
            this.shards = Builder._listAddAll(this.shards, list);
            return this;
        }

        public final Builder shards(ShardRecovery value, ShardRecovery ... values) {
            this.shards = Builder._listAdd(this.shards, value, values);
            return this;
        }

        public final Builder shards(Function<ShardRecovery.Builder, ObjectBuilder<ShardRecovery>> fn) {
            return this.shards(fn.apply(new ShardRecovery.Builder()).build(), new ShardRecovery[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RecoveryStatus build() {
            this._checkSingleUse();
            return new RecoveryStatus(this);
        }
    }
}

