/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.get_sample;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class RawDocument
implements JsonpSerializable {
    private final String index;
    private final Map<String, Property> source;
    public static final JsonpDeserializer<RawDocument> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RawDocument::setupRawDocumentDeserializer);

    private RawDocument(Builder builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.source = ApiTypeHelper.unmodifiableRequired(builder.source, (Object)this, "source");
    }

    public static RawDocument of(Function<Builder, ObjectBuilder<RawDocument>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    public final Map<String, Property> source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.write(this.index);
        if (ApiTypeHelper.isDefined(this.source)) {
            generator.writeKey("source");
            generator.writeStartObject();
            for (Map.Entry<String, Property> item0 : this.source.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRawDocumentDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::source, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "source");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RawDocument> {
        private String index;
        private Map<String, Property> source;

        public Builder() {
        }

        private Builder(RawDocument instance) {
            this.index = instance.index;
            this.source = instance.source;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder source(Map<String, Property> map) {
            this.source = Builder._mapPutAll(this.source, map);
            return this;
        }

        public final Builder source(String key, Property value) {
            this.source = Builder._mapPut(this.source, key, value);
            return this;
        }

        public final Builder source(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.source(key, fn.apply(new Property.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RawDocument build() {
            this._checkSingleUse();
            return new RawDocument(this);
        }
    }
}

