/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.IndexMode;
import co.elastic.clients.elasticsearch.indices.ResolveIndexResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ResolveIndexRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean allowNoIndices;
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Boolean ignoreUnavailable;
    private final List<IndexMode> mode;
    private final List<String> name;
    @Nullable
    private final String projectRouting;
    public static final JsonpDeserializer<ResolveIndexRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResolveIndexRequest::setupResolveIndexRequestDeserializer);
    public static final Endpoint<ResolveIndexRequest, ResolveIndexResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ResolveIndexRequest, ResolveIndexResponse>("es/indices.resolve_index", request -> "POST", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_resolve");
            buf.append("/index");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("name", request.name.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (ApiTypeHelper.isDefined(request.mode)) {
            params.put("mode", request.mode.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, ResolveIndexResponse._DESERIALIZER);

    private ResolveIndexRequest(Builder builder) {
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.mode = ApiTypeHelper.unmodifiable(builder.mode);
        this.name = ApiTypeHelper.unmodifiableRequired(builder.name, (Object)this, "name");
        this.projectRouting = builder.projectRouting;
    }

    public static ResolveIndexRequest of(Function<Builder, ObjectBuilder<ResolveIndexRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public final List<IndexMode> mode() {
        return this.mode;
    }

    public final List<String> name() {
        return this.name;
    }

    @Nullable
    public final String projectRouting() {
        return this.projectRouting;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.projectRouting != null) {
            generator.writeKey("project_routing");
            generator.write(this.projectRouting);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupResolveIndexRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::projectRouting, JsonpDeserializer.stringDeserializer(), "project_routing");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ResolveIndexRequest> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private List<IndexMode> mode;
        private List<String> name;
        @Nullable
        private String projectRouting;

        public Builder() {
        }

        private Builder(ResolveIndexRequest instance) {
            this.allowNoIndices = instance.allowNoIndices;
            this.expandWildcards = instance.expandWildcards;
            this.ignoreUnavailable = instance.ignoreUnavailable;
            this.mode = instance.mode;
            this.name = instance.name;
            this.projectRouting = instance.projectRouting;
        }

        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder mode(List<IndexMode> list) {
            this.mode = Builder._listAddAll(this.mode, list);
            return this;
        }

        public final Builder mode(IndexMode value, IndexMode ... values) {
            this.mode = Builder._listAdd(this.mode, value, values);
            return this;
        }

        public final Builder name(List<String> list) {
            this.name = Builder._listAddAll(this.name, list);
            return this;
        }

        public final Builder name(String value, String ... values) {
            this.name = Builder._listAdd(this.name, value, values);
            return this;
        }

        public final Builder projectRouting(@Nullable String value) {
            this.projectRouting = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ResolveIndexRequest build() {
            this._checkSingleUse();
            return new ResolveIndexRequest(this);
        }
    }
}

