/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch.indices.PutAliasResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutAliasRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Query filter;
    private final List<String> index;
    private final List<String> indexRouting;
    @Nullable
    private final Boolean isWriteIndex;
    @Nullable
    private final Time masterTimeout;
    private final String name;
    private final List<String> routing;
    private final List<String> searchRouting;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutAliasRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutAliasRequest::setupPutAliasRequestDeserializer);
    public static final Endpoint<PutAliasRequest, PutAliasResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutAliasRequest, PutAliasResponse>("es/indices.put_alias", request -> "PUT", request -> {
        boolean _name = true;
        int _index = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_alias");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_aliases");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        int _index = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("index", request.index.stream().map(v -> v).collect(Collectors.joining(",")));
            params.put("name", request.name);
        }
        if (propsSet == 3) {
            params.put("index", request.index.stream().map(v -> v).collect(Collectors.joining(",")));
            params.put("name", request.name);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutAliasResponse._DESERIALIZER);

    private PutAliasRequest(Builder builder) {
        this.filter = builder.filter;
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.indexRouting = ApiTypeHelper.unmodifiable(builder.indexRouting);
        this.isWriteIndex = builder.isWriteIndex;
        this.masterTimeout = builder.masterTimeout;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.routing = ApiTypeHelper.unmodifiable(builder.routing);
        this.searchRouting = ApiTypeHelper.unmodifiable(builder.searchRouting);
        this.timeout = builder.timeout;
    }

    public static PutAliasRequest of(Function<Builder, ObjectBuilder<PutAliasRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    public final List<String> index() {
        return this.index;
    }

    public final List<String> indexRouting() {
        return this.indexRouting;
    }

    @Nullable
    public final Boolean isWriteIndex() {
        return this.isWriteIndex;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final String name() {
        return this.name;
    }

    public final List<String> routing() {
        return this.routing;
    }

    public final List<String> searchRouting() {
        return this.searchRouting;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.indexRouting)) {
            generator.writeKey("index_routing");
            generator.writeStartArray();
            for (String item0 : this.indexRouting) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.isWriteIndex != null) {
            generator.writeKey("is_write_index");
            generator.write(this.isWriteIndex.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.routing)) {
            generator.writeKey("routing");
            generator.writeStartArray();
            for (String item0 : this.routing) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.searchRouting)) {
            generator.writeKey("search_routing");
            generator.writeStartArray();
            for (String item0 : this.searchRouting) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutAliasRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
        op.add(Builder::indexRouting, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_routing");
        op.add(Builder::isWriteIndex, JsonpDeserializer.booleanDeserializer(), "is_write_index");
        op.add(Builder::routing, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "routing");
        op.add(Builder::searchRouting, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "search_routing");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutAliasRequest> {
        @Nullable
        private Query filter;
        private List<String> index;
        @Nullable
        private List<String> indexRouting;
        @Nullable
        private Boolean isWriteIndex;
        @Nullable
        private Time masterTimeout;
        private String name;
        @Nullable
        private List<String> routing;
        @Nullable
        private List<String> searchRouting;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(PutAliasRequest instance) {
            this.filter = instance.filter;
            this.index = instance.index;
            this.indexRouting = instance.indexRouting;
            this.isWriteIndex = instance.isWriteIndex;
            this.masterTimeout = instance.masterTimeout;
            this.name = instance.name;
            this.routing = instance.routing;
            this.searchRouting = instance.searchRouting;
            this.timeout = instance.timeout;
        }

        public final Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public final Builder filter(QueryVariant value) {
            this.filter = value._toQuery();
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder indexRouting(List<String> list) {
            this.indexRouting = Builder._listAddAll(this.indexRouting, list);
            return this;
        }

        public final Builder indexRouting(String value, String ... values) {
            this.indexRouting = Builder._listAdd(this.indexRouting, value, values);
            return this;
        }

        public final Builder isWriteIndex(@Nullable Boolean value) {
            this.isWriteIndex = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder routing(List<String> list) {
            this.routing = Builder._listAddAll(this.routing, list);
            return this;
        }

        public final Builder routing(String value, String ... values) {
            this.routing = Builder._listAdd(this.routing, value, values);
            return this;
        }

        public final Builder searchRouting(List<String> list) {
            this.searchRouting = Builder._listAddAll(this.searchRouting, list);
            return this;
        }

        public final Builder searchRouting(String value, String ... values) {
            this.searchRouting = Builder._listAdd(this.searchRouting, value, values);
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutAliasRequest build() {
            this._checkSingleUse();
            return new PutAliasRequest(this);
        }
    }
}

