/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetSampleStatsResponse
implements JsonpSerializable {
    private final long potentialSamples;
    private final long samplesRejectedForMaxSamplesExceeded;
    private final long samplesRejectedForCondition;
    private final long samplesRejectedForRate;
    private final long samplesRejectedForException;
    private final long samplesRejectedForSize;
    private final long samplesAccepted;
    @Nullable
    private final Time timeSampling;
    private final long timeSamplingMillis;
    @Nullable
    private final Time timeEvaluatingCondition;
    private final long timeEvaluatingConditionMillis;
    @Nullable
    private final Time timeCompilingCondition;
    private final long timeCompilingConditionMillis;
    @Nullable
    private final String lastException;
    public static final JsonpDeserializer<GetSampleStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetSampleStatsResponse::setupGetSampleStatsResponseDeserializer);

    private GetSampleStatsResponse(Builder builder) {
        this.potentialSamples = ApiTypeHelper.requireNonNull(builder.potentialSamples, (Object)this, "potentialSamples", 0L);
        this.samplesRejectedForMaxSamplesExceeded = ApiTypeHelper.requireNonNull(builder.samplesRejectedForMaxSamplesExceeded, (Object)this, "samplesRejectedForMaxSamplesExceeded", 0L);
        this.samplesRejectedForCondition = ApiTypeHelper.requireNonNull(builder.samplesRejectedForCondition, (Object)this, "samplesRejectedForCondition", 0L);
        this.samplesRejectedForRate = ApiTypeHelper.requireNonNull(builder.samplesRejectedForRate, (Object)this, "samplesRejectedForRate", 0L);
        this.samplesRejectedForException = ApiTypeHelper.requireNonNull(builder.samplesRejectedForException, (Object)this, "samplesRejectedForException", 0L);
        this.samplesRejectedForSize = ApiTypeHelper.requireNonNull(builder.samplesRejectedForSize, (Object)this, "samplesRejectedForSize", 0L);
        this.samplesAccepted = ApiTypeHelper.requireNonNull(builder.samplesAccepted, (Object)this, "samplesAccepted", 0L);
        this.timeSampling = builder.timeSampling;
        this.timeSamplingMillis = ApiTypeHelper.requireNonNull(builder.timeSamplingMillis, (Object)this, "timeSamplingMillis", 0L);
        this.timeEvaluatingCondition = builder.timeEvaluatingCondition;
        this.timeEvaluatingConditionMillis = ApiTypeHelper.requireNonNull(builder.timeEvaluatingConditionMillis, (Object)this, "timeEvaluatingConditionMillis", 0L);
        this.timeCompilingCondition = builder.timeCompilingCondition;
        this.timeCompilingConditionMillis = ApiTypeHelper.requireNonNull(builder.timeCompilingConditionMillis, (Object)this, "timeCompilingConditionMillis", 0L);
        this.lastException = builder.lastException;
    }

    public static GetSampleStatsResponse of(Function<Builder, ObjectBuilder<GetSampleStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long potentialSamples() {
        return this.potentialSamples;
    }

    public final long samplesRejectedForMaxSamplesExceeded() {
        return this.samplesRejectedForMaxSamplesExceeded;
    }

    public final long samplesRejectedForCondition() {
        return this.samplesRejectedForCondition;
    }

    public final long samplesRejectedForRate() {
        return this.samplesRejectedForRate;
    }

    public final long samplesRejectedForException() {
        return this.samplesRejectedForException;
    }

    public final long samplesRejectedForSize() {
        return this.samplesRejectedForSize;
    }

    public final long samplesAccepted() {
        return this.samplesAccepted;
    }

    @Nullable
    public final Time timeSampling() {
        return this.timeSampling;
    }

    public final long timeSamplingMillis() {
        return this.timeSamplingMillis;
    }

    @Nullable
    public final Time timeEvaluatingCondition() {
        return this.timeEvaluatingCondition;
    }

    public final long timeEvaluatingConditionMillis() {
        return this.timeEvaluatingConditionMillis;
    }

    @Nullable
    public final Time timeCompilingCondition() {
        return this.timeCompilingCondition;
    }

    public final long timeCompilingConditionMillis() {
        return this.timeCompilingConditionMillis;
    }

    @Nullable
    public final String lastException() {
        return this.lastException;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("potential_samples");
        generator.write(this.potentialSamples);
        generator.writeKey("samples_rejected_for_max_samples_exceeded");
        generator.write(this.samplesRejectedForMaxSamplesExceeded);
        generator.writeKey("samples_rejected_for_condition");
        generator.write(this.samplesRejectedForCondition);
        generator.writeKey("samples_rejected_for_rate");
        generator.write(this.samplesRejectedForRate);
        generator.writeKey("samples_rejected_for_exception");
        generator.write(this.samplesRejectedForException);
        generator.writeKey("samples_rejected_for_size");
        generator.write(this.samplesRejectedForSize);
        generator.writeKey("samples_accepted");
        generator.write(this.samplesAccepted);
        if (this.timeSampling != null) {
            generator.writeKey("time_sampling");
            this.timeSampling.serialize(generator, mapper);
        }
        generator.writeKey("time_sampling_millis");
        generator.write(this.timeSamplingMillis);
        if (this.timeEvaluatingCondition != null) {
            generator.writeKey("time_evaluating_condition");
            this.timeEvaluatingCondition.serialize(generator, mapper);
        }
        generator.writeKey("time_evaluating_condition_millis");
        generator.write(this.timeEvaluatingConditionMillis);
        if (this.timeCompilingCondition != null) {
            generator.writeKey("time_compiling_condition");
            this.timeCompilingCondition.serialize(generator, mapper);
        }
        generator.writeKey("time_compiling_condition_millis");
        generator.write(this.timeCompilingConditionMillis);
        if (this.lastException != null) {
            generator.writeKey("last_exception");
            generator.write(this.lastException);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetSampleStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::potentialSamples, JsonpDeserializer.longDeserializer(), "potential_samples");
        op.add(Builder::samplesRejectedForMaxSamplesExceeded, JsonpDeserializer.longDeserializer(), "samples_rejected_for_max_samples_exceeded");
        op.add(Builder::samplesRejectedForCondition, JsonpDeserializer.longDeserializer(), "samples_rejected_for_condition");
        op.add(Builder::samplesRejectedForRate, JsonpDeserializer.longDeserializer(), "samples_rejected_for_rate");
        op.add(Builder::samplesRejectedForException, JsonpDeserializer.longDeserializer(), "samples_rejected_for_exception");
        op.add(Builder::samplesRejectedForSize, JsonpDeserializer.longDeserializer(), "samples_rejected_for_size");
        op.add(Builder::samplesAccepted, JsonpDeserializer.longDeserializer(), "samples_accepted");
        op.add(Builder::timeSampling, Time._DESERIALIZER, "time_sampling");
        op.add(Builder::timeSamplingMillis, JsonpDeserializer.longDeserializer(), "time_sampling_millis");
        op.add(Builder::timeEvaluatingCondition, Time._DESERIALIZER, "time_evaluating_condition");
        op.add(Builder::timeEvaluatingConditionMillis, JsonpDeserializer.longDeserializer(), "time_evaluating_condition_millis");
        op.add(Builder::timeCompilingCondition, Time._DESERIALIZER, "time_compiling_condition");
        op.add(Builder::timeCompilingConditionMillis, JsonpDeserializer.longDeserializer(), "time_compiling_condition_millis");
        op.add(Builder::lastException, JsonpDeserializer.stringDeserializer(), "last_exception");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetSampleStatsResponse> {
        private Long potentialSamples;
        private Long samplesRejectedForMaxSamplesExceeded;
        private Long samplesRejectedForCondition;
        private Long samplesRejectedForRate;
        private Long samplesRejectedForException;
        private Long samplesRejectedForSize;
        private Long samplesAccepted;
        @Nullable
        private Time timeSampling;
        private Long timeSamplingMillis;
        @Nullable
        private Time timeEvaluatingCondition;
        private Long timeEvaluatingConditionMillis;
        @Nullable
        private Time timeCompilingCondition;
        private Long timeCompilingConditionMillis;
        @Nullable
        private String lastException;

        public final Builder potentialSamples(long value) {
            this.potentialSamples = value;
            return this;
        }

        public final Builder samplesRejectedForMaxSamplesExceeded(long value) {
            this.samplesRejectedForMaxSamplesExceeded = value;
            return this;
        }

        public final Builder samplesRejectedForCondition(long value) {
            this.samplesRejectedForCondition = value;
            return this;
        }

        public final Builder samplesRejectedForRate(long value) {
            this.samplesRejectedForRate = value;
            return this;
        }

        public final Builder samplesRejectedForException(long value) {
            this.samplesRejectedForException = value;
            return this;
        }

        public final Builder samplesRejectedForSize(long value) {
            this.samplesRejectedForSize = value;
            return this;
        }

        public final Builder samplesAccepted(long value) {
            this.samplesAccepted = value;
            return this;
        }

        public final Builder timeSampling(@Nullable Time value) {
            this.timeSampling = value;
            return this;
        }

        public final Builder timeSampling(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeSampling(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeSamplingMillis(long value) {
            this.timeSamplingMillis = value;
            return this;
        }

        public final Builder timeEvaluatingCondition(@Nullable Time value) {
            this.timeEvaluatingCondition = value;
            return this;
        }

        public final Builder timeEvaluatingCondition(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeEvaluatingCondition(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeEvaluatingConditionMillis(long value) {
            this.timeEvaluatingConditionMillis = value;
            return this;
        }

        public final Builder timeCompilingCondition(@Nullable Time value) {
            this.timeCompilingCondition = value;
            return this;
        }

        public final Builder timeCompilingCondition(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeCompilingCondition(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeCompilingConditionMillis(long value) {
            this.timeCompilingConditionMillis = value;
            return this;
        }

        public final Builder lastException(@Nullable String value) {
            this.lastException = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetSampleStatsResponse build() {
            this._checkSingleUse();
            return new GetSampleStatsResponse(this);
        }
    }
}

