/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.indices.SamplingMethod;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DownsampleConfig
implements JsonpSerializable {
    private final Time fixedInterval;
    @Nullable
    private final SamplingMethod samplingMethod;
    public static final JsonpDeserializer<DownsampleConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DownsampleConfig::setupDownsampleConfigDeserializer);

    private DownsampleConfig(Builder builder) {
        this.fixedInterval = ApiTypeHelper.requireNonNull(builder.fixedInterval, this, "fixedInterval");
        this.samplingMethod = builder.samplingMethod;
    }

    public static DownsampleConfig of(Function<Builder, ObjectBuilder<DownsampleConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Time fixedInterval() {
        return this.fixedInterval;
    }

    @Nullable
    public final SamplingMethod samplingMethod() {
        return this.samplingMethod;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("fixed_interval");
        this.fixedInterval.serialize(generator, mapper);
        if (this.samplingMethod != null) {
            generator.writeKey("sampling_method");
            this.samplingMethod.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDownsampleConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fixedInterval, Time._DESERIALIZER, "fixed_interval");
        op.add(Builder::samplingMethod, SamplingMethod._DESERIALIZER, "sampling_method");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DownsampleConfig> {
        private Time fixedInterval;
        @Nullable
        private SamplingMethod samplingMethod;

        public Builder() {
        }

        private Builder(DownsampleConfig instance) {
            this.fixedInterval = instance.fixedInterval;
            this.samplingMethod = instance.samplingMethod;
        }

        public final Builder fixedInterval(Time value) {
            this.fixedInterval = value;
            return this;
        }

        public final Builder fixedInterval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.fixedInterval(fn.apply(new Time.Builder()).build());
        }

        public final Builder samplingMethod(@Nullable SamplingMethod value) {
            this.samplingMethod = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DownsampleConfig build() {
            this._checkSingleUse();
            return new DownsampleConfig(this);
        }
    }
}

