/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.DataStreamFailureStore;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataStreamOptions
implements JsonpSerializable {
    @Nullable
    private final DataStreamFailureStore failureStore;
    public static final JsonpDeserializer<DataStreamOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamOptions::setupDataStreamOptionsDeserializer);

    private DataStreamOptions(Builder builder) {
        this.failureStore = builder.failureStore;
    }

    public static DataStreamOptions of(Function<Builder, ObjectBuilder<DataStreamOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DataStreamFailureStore failureStore() {
        return this.failureStore;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.failureStore != null) {
            generator.writeKey("failure_store");
            this.failureStore.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDataStreamOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::failureStore, DataStreamFailureStore._DESERIALIZER, "failure_store");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStreamOptions> {
        @Nullable
        private DataStreamFailureStore failureStore;

        public Builder() {
        }

        private Builder(DataStreamOptions instance) {
            this.failureStore = instance.failureStore;
        }

        public final Builder failureStore(@Nullable DataStreamFailureStore value) {
            this.failureStore = value;
            return this;
        }

        public final Builder failureStore(Function<DataStreamFailureStore.Builder, ObjectBuilder<DataStreamFailureStore>> fn) {
            return this.failureStore(fn.apply(new DataStreamFailureStore.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamOptions build() {
            this._checkSingleUse();
            return new DataStreamOptions(this);
        }
    }
}

