/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ShrinkAction
implements JsonpSerializable {
    @Nullable
    private final Integer numberOfShards;
    @Nullable
    private final String maxPrimaryShardSize;
    @Nullable
    private final Boolean allowWriteAfterShrink;
    public static final JsonpDeserializer<ShrinkAction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShrinkAction::setupShrinkActionDeserializer);

    private ShrinkAction(Builder builder) {
        this.numberOfShards = builder.numberOfShards;
        this.maxPrimaryShardSize = builder.maxPrimaryShardSize;
        this.allowWriteAfterShrink = builder.allowWriteAfterShrink;
    }

    public static ShrinkAction of(Function<Builder, ObjectBuilder<ShrinkAction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer numberOfShards() {
        return this.numberOfShards;
    }

    @Nullable
    public final String maxPrimaryShardSize() {
        return this.maxPrimaryShardSize;
    }

    @Nullable
    public final Boolean allowWriteAfterShrink() {
        return this.allowWriteAfterShrink;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.numberOfShards != null) {
            generator.writeKey("number_of_shards");
            generator.write(this.numberOfShards.intValue());
        }
        if (this.maxPrimaryShardSize != null) {
            generator.writeKey("max_primary_shard_size");
            generator.write(this.maxPrimaryShardSize);
        }
        if (this.allowWriteAfterShrink != null) {
            generator.writeKey("allow_write_after_shrink");
            generator.write(this.allowWriteAfterShrink.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupShrinkActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::numberOfShards, JsonpDeserializer.integerDeserializer(), "number_of_shards");
        op.add(Builder::maxPrimaryShardSize, JsonpDeserializer.stringDeserializer(), "max_primary_shard_size");
        op.add(Builder::allowWriteAfterShrink, JsonpDeserializer.booleanDeserializer(), "allow_write_after_shrink");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShrinkAction> {
        @Nullable
        private Integer numberOfShards;
        @Nullable
        private String maxPrimaryShardSize;
        @Nullable
        private Boolean allowWriteAfterShrink;

        public Builder() {
        }

        private Builder(ShrinkAction instance) {
            this.numberOfShards = instance.numberOfShards;
            this.maxPrimaryShardSize = instance.maxPrimaryShardSize;
            this.allowWriteAfterShrink = instance.allowWriteAfterShrink;
        }

        public final Builder numberOfShards(@Nullable Integer value) {
            this.numberOfShards = value;
            return this;
        }

        public final Builder maxPrimaryShardSize(@Nullable String value) {
            this.maxPrimaryShardSize = value;
            return this;
        }

        public final Builder allowWriteAfterShrink(@Nullable Boolean value) {
            this.allowWriteAfterShrink = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShrinkAction build() {
            this._checkSingleUse();
            return new ShrinkAction(this);
        }
    }
}

