/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.esql;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.esql.PutViewResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

@JsonpDeserializable
public class PutViewRequest
extends RequestBase
implements JsonpSerializable {
    private final String name;
    private final String query;
    public static final JsonpDeserializer<PutViewRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutViewRequest::setupPutViewRequestDeserializer);
    public static final Endpoint<PutViewRequest, PutViewResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutViewRequest, PutViewResponse>("es/esql.put_view", request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_query");
            buf.append("/view");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("name", request.name);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutViewResponse._DESERIALIZER);

    private PutViewRequest(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
    }

    public static PutViewRequest of(Function<Builder, ObjectBuilder<PutViewRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final String query() {
        return this.query;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("query");
        generator.write(this.query);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutViewRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutViewRequest> {
        private String name;
        private String query;

        public Builder() {
        }

        private Builder(PutViewRequest instance) {
            this.name = instance.name;
            this.query = instance.query;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutViewRequest build() {
            this._checkSingleUse();
            return new PutViewRequest(this);
        }
    }
}

