/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.enrich;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.enrich.EnrichPolicy;
import co.elastic.clients.elasticsearch.enrich.PutPolicyResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutPolicyRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final EnrichPolicy geoMatch;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final EnrichPolicy match;
    private final String name;
    @Nullable
    private final EnrichPolicy range;
    public static final JsonpDeserializer<PutPolicyRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutPolicyRequest::setupPutPolicyRequestDeserializer);
    public static final Endpoint<PutPolicyRequest, PutPolicyResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutPolicyRequest, PutPolicyResponse>("es/enrich.put_policy", request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_enrich");
            buf.append("/policy");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("name", request.name);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutPolicyResponse._DESERIALIZER);

    private PutPolicyRequest(Builder builder) {
        this.geoMatch = builder.geoMatch;
        this.masterTimeout = builder.masterTimeout;
        this.match = builder.match;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.range = builder.range;
    }

    public static PutPolicyRequest of(Function<Builder, ObjectBuilder<PutPolicyRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final EnrichPolicy geoMatch() {
        return this.geoMatch;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final EnrichPolicy match() {
        return this.match;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final EnrichPolicy range() {
        return this.range;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.geoMatch != null) {
            generator.writeKey("geo_match");
            this.geoMatch.serialize(generator, mapper);
        }
        if (this.match != null) {
            generator.writeKey("match");
            this.match.serialize(generator, mapper);
        }
        if (this.range != null) {
            generator.writeKey("range");
            this.range.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutPolicyRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::geoMatch, EnrichPolicy._DESERIALIZER, "geo_match");
        op.add(Builder::match, EnrichPolicy._DESERIALIZER, "match");
        op.add(Builder::range, EnrichPolicy._DESERIALIZER, "range");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutPolicyRequest> {
        @Nullable
        private EnrichPolicy geoMatch;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private EnrichPolicy match;
        private String name;
        @Nullable
        private EnrichPolicy range;

        public Builder() {
        }

        private Builder(PutPolicyRequest instance) {
            this.geoMatch = instance.geoMatch;
            this.masterTimeout = instance.masterTimeout;
            this.match = instance.match;
            this.name = instance.name;
            this.range = instance.range;
        }

        public final Builder geoMatch(@Nullable EnrichPolicy value) {
            this.geoMatch = value;
            return this;
        }

        public final Builder geoMatch(Function<EnrichPolicy.Builder, ObjectBuilder<EnrichPolicy>> fn) {
            return this.geoMatch(fn.apply(new EnrichPolicy.Builder()).build());
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder match(@Nullable EnrichPolicy value) {
            this.match = value;
            return this;
        }

        public final Builder match(Function<EnrichPolicy.Builder, ObjectBuilder<EnrichPolicy>> fn) {
            return this.match(fn.apply(new EnrichPolicy.Builder()).build());
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder range(@Nullable EnrichPolicy value) {
            this.range = value;
            return this;
        }

        public final Builder range(Function<EnrichPolicy.Builder, ObjectBuilder<EnrichPolicy>> fn) {
            return this.range(fn.apply(new EnrichPolicy.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutPolicyRequest build() {
            this._checkSingleUse();
            return new PutPolicyRequest(this);
        }
    }
}

