/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DfsStatisticsBreakdown
implements JsonpSerializable {
    private final long collectionStatistics;
    private final long collectionStatisticsCount;
    private final long createWeight;
    private final long createWeightCount;
    private final long rewrite;
    private final long rewriteCount;
    private final long termStatistics;
    private final long termStatisticsCount;
    public static final JsonpDeserializer<DfsStatisticsBreakdown> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DfsStatisticsBreakdown::setupDfsStatisticsBreakdownDeserializer);

    private DfsStatisticsBreakdown(Builder builder) {
        this.collectionStatistics = ApiTypeHelper.requireNonNull(builder.collectionStatistics, (Object)this, "collectionStatistics", 0L);
        this.collectionStatisticsCount = ApiTypeHelper.requireNonNull(builder.collectionStatisticsCount, (Object)this, "collectionStatisticsCount", 0L);
        this.createWeight = ApiTypeHelper.requireNonNull(builder.createWeight, (Object)this, "createWeight", 0L);
        this.createWeightCount = ApiTypeHelper.requireNonNull(builder.createWeightCount, (Object)this, "createWeightCount", 0L);
        this.rewrite = ApiTypeHelper.requireNonNull(builder.rewrite, (Object)this, "rewrite", 0L);
        this.rewriteCount = ApiTypeHelper.requireNonNull(builder.rewriteCount, (Object)this, "rewriteCount", 0L);
        this.termStatistics = ApiTypeHelper.requireNonNull(builder.termStatistics, (Object)this, "termStatistics", 0L);
        this.termStatisticsCount = ApiTypeHelper.requireNonNull(builder.termStatisticsCount, (Object)this, "termStatisticsCount", 0L);
    }

    public static DfsStatisticsBreakdown of(Function<Builder, ObjectBuilder<DfsStatisticsBreakdown>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long collectionStatistics() {
        return this.collectionStatistics;
    }

    public final long collectionStatisticsCount() {
        return this.collectionStatisticsCount;
    }

    public final long createWeight() {
        return this.createWeight;
    }

    public final long createWeightCount() {
        return this.createWeightCount;
    }

    public final long rewrite() {
        return this.rewrite;
    }

    public final long rewriteCount() {
        return this.rewriteCount;
    }

    public final long termStatistics() {
        return this.termStatistics;
    }

    public final long termStatisticsCount() {
        return this.termStatisticsCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("collection_statistics");
        generator.write(this.collectionStatistics);
        generator.writeKey("collection_statistics_count");
        generator.write(this.collectionStatisticsCount);
        generator.writeKey("create_weight");
        generator.write(this.createWeight);
        generator.writeKey("create_weight_count");
        generator.write(this.createWeightCount);
        generator.writeKey("rewrite");
        generator.write(this.rewrite);
        generator.writeKey("rewrite_count");
        generator.write(this.rewriteCount);
        generator.writeKey("term_statistics");
        generator.write(this.termStatistics);
        generator.writeKey("term_statistics_count");
        generator.write(this.termStatisticsCount);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDfsStatisticsBreakdownDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::collectionStatistics, JsonpDeserializer.longDeserializer(), "collection_statistics");
        op.add(Builder::collectionStatisticsCount, JsonpDeserializer.longDeserializer(), "collection_statistics_count");
        op.add(Builder::createWeight, JsonpDeserializer.longDeserializer(), "create_weight");
        op.add(Builder::createWeightCount, JsonpDeserializer.longDeserializer(), "create_weight_count");
        op.add(Builder::rewrite, JsonpDeserializer.longDeserializer(), "rewrite");
        op.add(Builder::rewriteCount, JsonpDeserializer.longDeserializer(), "rewrite_count");
        op.add(Builder::termStatistics, JsonpDeserializer.longDeserializer(), "term_statistics");
        op.add(Builder::termStatisticsCount, JsonpDeserializer.longDeserializer(), "term_statistics_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DfsStatisticsBreakdown> {
        private Long collectionStatistics;
        private Long collectionStatisticsCount;
        private Long createWeight;
        private Long createWeightCount;
        private Long rewrite;
        private Long rewriteCount;
        private Long termStatistics;
        private Long termStatisticsCount;

        public Builder() {
        }

        private Builder(DfsStatisticsBreakdown instance) {
            this.collectionStatistics = instance.collectionStatistics;
            this.collectionStatisticsCount = instance.collectionStatisticsCount;
            this.createWeight = instance.createWeight;
            this.createWeightCount = instance.createWeightCount;
            this.rewrite = instance.rewrite;
            this.rewriteCount = instance.rewriteCount;
            this.termStatistics = instance.termStatistics;
            this.termStatisticsCount = instance.termStatisticsCount;
        }

        public final Builder collectionStatistics(long value) {
            this.collectionStatistics = value;
            return this;
        }

        public final Builder collectionStatisticsCount(long value) {
            this.collectionStatisticsCount = value;
            return this;
        }

        public final Builder createWeight(long value) {
            this.createWeight = value;
            return this;
        }

        public final Builder createWeightCount(long value) {
            this.createWeightCount = value;
            return this;
        }

        public final Builder rewrite(long value) {
            this.rewrite = value;
            return this;
        }

        public final Builder rewriteCount(long value) {
            this.rewriteCount = value;
            return this;
        }

        public final Builder termStatistics(long value) {
            this.termStatistics = value;
            return this;
        }

        public final Builder termStatisticsCount(long value) {
            this.termStatisticsCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DfsStatisticsBreakdown build() {
            this._checkSingleUse();
            return new DfsStatisticsBreakdown(this);
        }
    }
}

