/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.UpdateIndexNameResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

@JsonpDeserializable
public class UpdateIndexNameRequest
extends RequestBase
implements JsonpSerializable {
    private final String connectorId;
    private final String indexName;
    private final boolean isExpNullIndexName;
    public static final JsonpDeserializer<UpdateIndexNameRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateIndexNameRequest::setupUpdateIndexNameRequestDeserializer);
    public static final Endpoint<UpdateIndexNameRequest, UpdateIndexNameResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateIndexNameRequest, UpdateIndexNameResponse>("es/connector.update_index_name", request -> "PUT", request -> {
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_connector");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.connectorId, buf);
            buf.append("/_index_name");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("connectorId", request.connectorId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateIndexNameResponse._DESERIALIZER);

    private UpdateIndexNameRequest(Builder builder) {
        this.connectorId = ApiTypeHelper.requireNonNull(builder.connectorId, this, "connectorId");
        this.indexName = builder.indexName;
        this.isExpNullIndexName = builder.isExpNullIndexName;
    }

    public static UpdateIndexNameRequest of(Function<Builder, ObjectBuilder<UpdateIndexNameRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final String indexName() {
        return this.indexName;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (!this.isExpNullIndexName) {
            generator.writeKey("index_name");
            generator.write(this.indexName);
        } else if (this.isExpNullIndexName) {
            generator.writeKey("index_name");
            generator.writeNull();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupUpdateIndexNameRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexName, JsonpDeserializer.stringDeserializer(), "index_name");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateIndexNameRequest> {
        private String connectorId;
        private String indexName;
        private boolean isExpNullIndexName;

        public Builder() {
        }

        private Builder(UpdateIndexNameRequest instance) {
            this.connectorId = instance.connectorId;
            this.indexName = instance.indexName;
        }

        public final Builder connectorId(String value) {
            this.connectorId = value;
            return this;
        }

        public final Builder indexName(String value) {
            this.indexName = value;
            this.isExpNullIndexName = false;
            return this;
        }

        public final Builder indexNameWithNull() {
            this.isExpNullIndexName = true;
            this.indexName = null;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateIndexNameRequest build() {
            this._checkSingleUse();
            return new UpdateIndexNameRequest(this);
        }
    }
}

