/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch._types.PluginStats;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterFileSystem;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterIngest;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterJvm;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterNetworkTypes;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterNodeCount;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterOperatingSystem;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterProcess;
import co.elastic.clients.elasticsearch.cluster.stats.IndexingPressure;
import co.elastic.clients.elasticsearch.cluster.stats.NodePackagingType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class ClusterNodes
implements JsonpSerializable {
    private final ClusterNodeCount count;
    private final Map<String, Integer> discoveryTypes;
    private final ClusterFileSystem fs;
    private final IndexingPressure indexingPressure;
    private final ClusterIngest ingest;
    private final ClusterJvm jvm;
    private final ClusterNetworkTypes networkTypes;
    private final ClusterOperatingSystem os;
    private final List<NodePackagingType> packagingTypes;
    private final List<PluginStats> plugins;
    private final ClusterProcess process;
    private final List<String> versions;
    public static final JsonpDeserializer<ClusterNodes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterNodes::setupClusterNodesDeserializer);

    private ClusterNodes(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.discoveryTypes = ApiTypeHelper.unmodifiableRequired(builder.discoveryTypes, (Object)this, "discoveryTypes");
        this.fs = ApiTypeHelper.requireNonNull(builder.fs, this, "fs");
        this.indexingPressure = ApiTypeHelper.requireNonNull(builder.indexingPressure, this, "indexingPressure");
        this.ingest = ApiTypeHelper.requireNonNull(builder.ingest, this, "ingest");
        this.jvm = ApiTypeHelper.requireNonNull(builder.jvm, this, "jvm");
        this.networkTypes = ApiTypeHelper.requireNonNull(builder.networkTypes, this, "networkTypes");
        this.os = ApiTypeHelper.requireNonNull(builder.os, this, "os");
        this.packagingTypes = ApiTypeHelper.unmodifiableRequired(builder.packagingTypes, (Object)this, "packagingTypes");
        this.plugins = ApiTypeHelper.unmodifiableRequired(builder.plugins, (Object)this, "plugins");
        this.process = ApiTypeHelper.requireNonNull(builder.process, this, "process");
        this.versions = ApiTypeHelper.unmodifiableRequired(builder.versions, (Object)this, "versions");
    }

    public static ClusterNodes of(Function<Builder, ObjectBuilder<ClusterNodes>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ClusterNodeCount count() {
        return this.count;
    }

    public final Map<String, Integer> discoveryTypes() {
        return this.discoveryTypes;
    }

    public final ClusterFileSystem fs() {
        return this.fs;
    }

    public final IndexingPressure indexingPressure() {
        return this.indexingPressure;
    }

    public final ClusterIngest ingest() {
        return this.ingest;
    }

    public final ClusterJvm jvm() {
        return this.jvm;
    }

    public final ClusterNetworkTypes networkTypes() {
        return this.networkTypes;
    }

    public final ClusterOperatingSystem os() {
        return this.os;
    }

    public final List<NodePackagingType> packagingTypes() {
        return this.packagingTypes;
    }

    public final List<PluginStats> plugins() {
        return this.plugins;
    }

    public final ClusterProcess process() {
        return this.process;
    }

    public final List<String> versions() {
        return this.versions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        this.count.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.discoveryTypes)) {
            generator.writeKey("discovery_types");
            generator.writeStartObject();
            for (Map.Entry<String, Integer> entry : this.discoveryTypes.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue().intValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("fs");
        this.fs.serialize(generator, mapper);
        generator.writeKey("indexing_pressure");
        this.indexingPressure.serialize(generator, mapper);
        generator.writeKey("ingest");
        this.ingest.serialize(generator, mapper);
        generator.writeKey("jvm");
        this.jvm.serialize(generator, mapper);
        generator.writeKey("network_types");
        this.networkTypes.serialize(generator, mapper);
        generator.writeKey("os");
        this.os.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.packagingTypes)) {
            generator.writeKey("packaging_types");
            generator.writeStartArray();
            for (NodePackagingType nodePackagingType : this.packagingTypes) {
                nodePackagingType.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.plugins)) {
            generator.writeKey("plugins");
            generator.writeStartArray();
            for (PluginStats pluginStats : this.plugins) {
                pluginStats.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("process");
        this.process.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.versions)) {
            generator.writeKey("versions");
            generator.writeStartArray();
            for (String string : this.versions) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupClusterNodesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, ClusterNodeCount._DESERIALIZER, "count");
        op.add(Builder::discoveryTypes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "discovery_types");
        op.add(Builder::fs, ClusterFileSystem._DESERIALIZER, "fs");
        op.add(Builder::indexingPressure, IndexingPressure._DESERIALIZER, "indexing_pressure");
        op.add(Builder::ingest, ClusterIngest._DESERIALIZER, "ingest");
        op.add(Builder::jvm, ClusterJvm._DESERIALIZER, "jvm");
        op.add(Builder::networkTypes, ClusterNetworkTypes._DESERIALIZER, "network_types");
        op.add(Builder::os, ClusterOperatingSystem._DESERIALIZER, "os");
        op.add(Builder::packagingTypes, JsonpDeserializer.arrayDeserializer(NodePackagingType._DESERIALIZER), "packaging_types");
        op.add(Builder::plugins, JsonpDeserializer.arrayDeserializer(PluginStats._DESERIALIZER), "plugins");
        op.add(Builder::process, ClusterProcess._DESERIALIZER, "process");
        op.add(Builder::versions, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "versions");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ClusterNodes> {
        private ClusterNodeCount count;
        private Map<String, Integer> discoveryTypes;
        private ClusterFileSystem fs;
        private IndexingPressure indexingPressure;
        private ClusterIngest ingest;
        private ClusterJvm jvm;
        private ClusterNetworkTypes networkTypes;
        private ClusterOperatingSystem os;
        private List<NodePackagingType> packagingTypes;
        private List<PluginStats> plugins;
        private ClusterProcess process;
        private List<String> versions;

        public Builder() {
        }

        private Builder(ClusterNodes instance) {
            this.count = instance.count;
            this.discoveryTypes = instance.discoveryTypes;
            this.fs = instance.fs;
            this.indexingPressure = instance.indexingPressure;
            this.ingest = instance.ingest;
            this.jvm = instance.jvm;
            this.networkTypes = instance.networkTypes;
            this.os = instance.os;
            this.packagingTypes = instance.packagingTypes;
            this.plugins = instance.plugins;
            this.process = instance.process;
            this.versions = instance.versions;
        }

        public final Builder count(ClusterNodeCount value) {
            this.count = value;
            return this;
        }

        public final Builder count(Function<ClusterNodeCount.Builder, ObjectBuilder<ClusterNodeCount>> fn) {
            return this.count(fn.apply(new ClusterNodeCount.Builder()).build());
        }

        public final Builder discoveryTypes(Map<String, Integer> map) {
            this.discoveryTypes = Builder._mapPutAll(this.discoveryTypes, map);
            return this;
        }

        public final Builder discoveryTypes(String key, Integer value) {
            this.discoveryTypes = Builder._mapPut(this.discoveryTypes, key, value);
            return this;
        }

        public final Builder fs(ClusterFileSystem value) {
            this.fs = value;
            return this;
        }

        public final Builder fs(Function<ClusterFileSystem.Builder, ObjectBuilder<ClusterFileSystem>> fn) {
            return this.fs(fn.apply(new ClusterFileSystem.Builder()).build());
        }

        public final Builder indexingPressure(IndexingPressure value) {
            this.indexingPressure = value;
            return this;
        }

        public final Builder indexingPressure(Function<IndexingPressure.Builder, ObjectBuilder<IndexingPressure>> fn) {
            return this.indexingPressure(fn.apply(new IndexingPressure.Builder()).build());
        }

        public final Builder ingest(ClusterIngest value) {
            this.ingest = value;
            return this;
        }

        public final Builder ingest(Function<ClusterIngest.Builder, ObjectBuilder<ClusterIngest>> fn) {
            return this.ingest(fn.apply(new ClusterIngest.Builder()).build());
        }

        public final Builder jvm(ClusterJvm value) {
            this.jvm = value;
            return this;
        }

        public final Builder jvm(Function<ClusterJvm.Builder, ObjectBuilder<ClusterJvm>> fn) {
            return this.jvm(fn.apply(new ClusterJvm.Builder()).build());
        }

        public final Builder networkTypes(ClusterNetworkTypes value) {
            this.networkTypes = value;
            return this;
        }

        public final Builder networkTypes(Function<ClusterNetworkTypes.Builder, ObjectBuilder<ClusterNetworkTypes>> fn) {
            return this.networkTypes(fn.apply(new ClusterNetworkTypes.Builder()).build());
        }

        public final Builder os(ClusterOperatingSystem value) {
            this.os = value;
            return this;
        }

        public final Builder os(Function<ClusterOperatingSystem.Builder, ObjectBuilder<ClusterOperatingSystem>> fn) {
            return this.os(fn.apply(new ClusterOperatingSystem.Builder()).build());
        }

        public final Builder packagingTypes(List<NodePackagingType> list) {
            this.packagingTypes = Builder._listAddAll(this.packagingTypes, list);
            return this;
        }

        public final Builder packagingTypes(NodePackagingType value, NodePackagingType ... values) {
            this.packagingTypes = Builder._listAdd(this.packagingTypes, value, values);
            return this;
        }

        public final Builder packagingTypes(Function<NodePackagingType.Builder, ObjectBuilder<NodePackagingType>> fn) {
            return this.packagingTypes(fn.apply(new NodePackagingType.Builder()).build(), new NodePackagingType[0]);
        }

        public final Builder plugins(List<PluginStats> list) {
            this.plugins = Builder._listAddAll(this.plugins, list);
            return this;
        }

        public final Builder plugins(PluginStats value, PluginStats ... values) {
            this.plugins = Builder._listAdd(this.plugins, value, values);
            return this;
        }

        public final Builder plugins(Function<PluginStats.Builder, ObjectBuilder<PluginStats>> fn) {
            return this.plugins(fn.apply(new PluginStats.Builder()).build(), new PluginStats[0]);
        }

        public final Builder process(ClusterProcess value) {
            this.process = value;
            return this;
        }

        public final Builder process(Function<ClusterProcess.Builder, ObjectBuilder<ClusterProcess>> fn) {
            return this.process(fn.apply(new ClusterProcess.Builder()).build());
        }

        public final Builder versions(List<String> list) {
            this.versions = Builder._listAddAll(this.versions, list);
            return this;
        }

        public final Builder versions(String value, String ... values) {
            this.versions = Builder._listAdd(this.versions, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterNodes build() {
            this._checkSingleUse();
            return new ClusterNodes(this);
        }
    }
}

