/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch.cluster.ComponentTemplateSummary;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ComponentTemplateNode
implements JsonpSerializable {
    private final ComponentTemplateSummary template;
    @Nullable
    private final Long version;
    private final Map<String, JsonData> meta;
    @Nullable
    private final Boolean deprecated;
    @Nullable
    private final DateTime createdDate;
    @Nullable
    private final Long createdDateMillis;
    @Nullable
    private final DateTime modifiedDate;
    @Nullable
    private final Long modifiedDateMillis;
    public static final JsonpDeserializer<ComponentTemplateNode> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ComponentTemplateNode::setupComponentTemplateNodeDeserializer);

    private ComponentTemplateNode(Builder builder) {
        this.template = ApiTypeHelper.requireNonNull(builder.template, this, "template");
        this.version = builder.version;
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.deprecated = builder.deprecated;
        this.createdDate = builder.createdDate;
        this.createdDateMillis = builder.createdDateMillis;
        this.modifiedDate = builder.modifiedDate;
        this.modifiedDateMillis = builder.modifiedDateMillis;
    }

    public static ComponentTemplateNode of(Function<Builder, ObjectBuilder<ComponentTemplateNode>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ComponentTemplateSummary template() {
        return this.template;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public final Boolean deprecated() {
        return this.deprecated;
    }

    @Nullable
    public final DateTime createdDate() {
        return this.createdDate;
    }

    @Nullable
    public final Long createdDateMillis() {
        return this.createdDateMillis;
    }

    @Nullable
    public final DateTime modifiedDate() {
        return this.modifiedDate;
    }

    @Nullable
    public final Long modifiedDateMillis() {
        return this.modifiedDateMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("template");
        this.template.serialize(generator, mapper);
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.meta.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.deprecated != null) {
            generator.writeKey("deprecated");
            generator.write(this.deprecated.booleanValue());
        }
        if (this.createdDate != null) {
            generator.writeKey("created_date");
            this.createdDate.serialize(generator, mapper);
        }
        if (this.createdDateMillis != null) {
            generator.writeKey("created_date_millis");
            generator.write(this.createdDateMillis.longValue());
        }
        if (this.modifiedDate != null) {
            generator.writeKey("modified_date");
            this.modifiedDate.serialize(generator, mapper);
        }
        if (this.modifiedDateMillis != null) {
            generator.writeKey("modified_date_millis");
            generator.write(this.modifiedDateMillis.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupComponentTemplateNodeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::template, ComponentTemplateSummary._DESERIALIZER, "template");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::deprecated, JsonpDeserializer.booleanDeserializer(), "deprecated");
        op.add(Builder::createdDate, DateTime._DESERIALIZER, "created_date");
        op.add(Builder::createdDateMillis, JsonpDeserializer.longDeserializer(), "created_date_millis");
        op.add(Builder::modifiedDate, DateTime._DESERIALIZER, "modified_date");
        op.add(Builder::modifiedDateMillis, JsonpDeserializer.longDeserializer(), "modified_date_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ComponentTemplateNode> {
        private ComponentTemplateSummary template;
        @Nullable
        private Long version;
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private Boolean deprecated;
        @Nullable
        private DateTime createdDate;
        @Nullable
        private Long createdDateMillis;
        @Nullable
        private DateTime modifiedDate;
        @Nullable
        private Long modifiedDateMillis;

        public Builder() {
        }

        private Builder(ComponentTemplateNode instance) {
            this.template = instance.template;
            this.version = instance.version;
            this.meta = instance.meta;
            this.deprecated = instance.deprecated;
            this.createdDate = instance.createdDate;
            this.createdDateMillis = instance.createdDateMillis;
            this.modifiedDate = instance.modifiedDate;
            this.modifiedDateMillis = instance.modifiedDateMillis;
        }

        public final Builder template(ComponentTemplateSummary value) {
            this.template = value;
            return this;
        }

        public final Builder template(Function<ComponentTemplateSummary.Builder, ObjectBuilder<ComponentTemplateSummary>> fn) {
            return this.template(fn.apply(new ComponentTemplateSummary.Builder()).build());
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        public final Builder deprecated(@Nullable Boolean value) {
            this.deprecated = value;
            return this;
        }

        public final Builder createdDate(@Nullable DateTime value) {
            this.createdDate = value;
            return this;
        }

        public final Builder createdDateMillis(@Nullable Long value) {
            this.createdDateMillis = value;
            return this;
        }

        public final Builder modifiedDate(@Nullable DateTime value) {
            this.modifiedDate = value;
            return this;
        }

        public final Builder modifiedDateMillis(@Nullable Long value) {
            this.modifiedDateMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ComponentTemplateNode build() {
            this._checkSingleUse();
            return new ComponentTemplateNode(this);
        }
    }
}

